/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.world.ChunkLoadEvent;

public class StructureSpawningListener
implements Listener {
    private final RuinedStructures999 plugin;
    private final Random random = new Random();

    public StructureSpawningListener(RuinedStructures999 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!event.isNewChunk()) {
            return;
        }
        if (this.plugin.getConfig().getStringList("disabled-worlds").contains(event.getWorld().getName())) {
            return;
        }
        for (RuinedStructures999.Structure structure : this.plugin.getStructures().values()) {
            Location loc;
            if (!(this.random.nextDouble() < this.plugin.getConfig().getDouble(structure.getName() + ".spawn-chance-per-chunk", 0.01)) || (loc = structure.findValidSpawnLocation(event.getChunk())) == null) continue;
            Block block = loc.getBlock();
            BlockCanBuildEvent canBuildEvent = new BlockCanBuildEvent(block, Bukkit.getPluginManager().getPlugin("RuinedStructures999").getServer().createBlockData(Material.STONE), true);
            Bukkit.getPluginManager().callEvent((Event)canBuildEvent);
            if (!canBuildEvent.isBuildable()) continue;
            structure.generate(loc);
            this.plugin.getLogger().info("Spawned structure " + structure.getName() + " at " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ());
        }
    }
}

