/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class SunkenGraveyard
extends RuinedStructures999.Structure {
    private final Random rand = new Random();

    public SunkenGraveyard(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 15; ++attempt) {
            int baseX = chunk.getX() * 16 + this.rand.nextInt(16);
            int baseZ = chunk.getZ() * 16 + this.rand.nextInt(16);
            int seaLevel = world.getSeaLevel();
            int y = seaLevel - 10 - this.rand.nextInt(20);
            Biome biome = world.getBiome(baseX, y, baseZ);
            if (!this.getAllowedBiomes().contains(biome)) continue;
            Block block = world.getBlockAt(baseX, y, baseZ);
            Block blockAbove = world.getBlockAt(baseX, y + 1, baseZ);
            if (block.isPassable() || !blockAbove.isLiquid()) continue;
            return new Location(world, (double)baseX, (double)(y + 1), (double)baseZ);
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        int size = 15;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                Material groundMat = this.rand.nextDouble() < 0.4 ? Material.GRAVEL : (this.rand.nextDouble() < 0.5 ? Material.SAND : Material.CLAY);
                world.getBlockAt(baseX + x, baseY - 1, baseZ + z).setType(groundMat);
                if (!(this.rand.nextDouble() < 0.3)) continue;
                world.getBlockAt(baseX + x, baseY, baseZ + z).setType(Material.SEAGRASS);
            }
        }
        ArrayList<Location> graveLocations = new ArrayList<Location>();
        for (int i = 0; i < 10 + this.rand.nextInt(8); ++i) {
            int gZ;
            int gX = baseX + this.rand.nextInt(size * 2) - size;
            Location graveLoc = new Location(world, (double)gX, (double)baseY, (double)(gZ = baseZ + this.rand.nextInt(size * 2) - size));
            if (!(graveLoc.distance(base) > 4.0)) continue;
            this.buildGrave(world, graveLoc);
            graveLocations.add(graveLoc);
        }
        if (!graveLocations.isEmpty()) {
            Location hiddenGrave = (Location)graveLocations.get(this.rand.nextInt(graveLocations.size()));
            Block spawnerBlock = world.getBlockAt(hiddenGrave.getBlockX(), hiddenGrave.getBlockY() - 3, hiddenGrave.getBlockZ());
            spawnerBlock.setType(Material.SPAWNER);
            BlockState blockState = spawnerBlock.getState();
            if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                spawner.setSpawnedType(EntityType.DROWNED);
                spawner.update();
            }
            Block coffinBlock = world.getBlockAt(hiddenGrave.getBlockX(), hiddenGrave.getBlockY() - 2, hiddenGrave.getBlockZ());
            coffinBlock.setType(Material.BARREL);
            if (coffinBlock.getState() instanceof Barrel) {
                RuinedStructures999.plugin.addChest(coffinBlock.getLocation(), this.getName());
            }
        }
        this.buildCrypt(world, new Location(world, (double)(baseX + size / 2), (double)baseY, (double)(baseZ + size / 2)));
    }

    private void buildGrave(World world, Location loc) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        Material mat = this.rand.nextDouble() < 0.6 ? Material.MOSSY_STONE_BRICKS : Material.PRISMARINE_BRICKS;
        int type = this.rand.nextInt(3);
        if (type == 0) {
            world.getBlockAt(x, y, z).setType(mat);
            world.getBlockAt(x, y + 1, z).setType(mat);
        } else if (type == 1) {
            world.getBlockAt(x, y, z).setType(Material.STONE_BRICK_SLAB);
        } else {
            world.getBlockAt(x, y, z).setType(Material.MOSSY_COBBLESTONE_WALL);
            world.getBlockAt(x, y + 1, z).setType(Material.MOSSY_COBBLESTONE_WALL);
        }
    }

    private void buildCrypt(World world, Location loc) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 4; ++k) {
                    if (!(this.rand.nextDouble() > 0.35)) continue;
                    if (i == 0 || i == 5 || j == 0 || j == 5) {
                        world.getBlockAt(x + i, y + k, z + j).setType(Material.CRACKED_STONE_BRICKS);
                        continue;
                    }
                    if (k != 3) continue;
                    world.getBlockAt(x + i, y + k, z + j).setType(Material.PRISMARINE_SLAB);
                }
            }
        }
        Block spawnerBlock = world.getBlockAt(x + 2, y, z + 2);
        spawnerBlock.setType(Material.SPAWNER);
        BlockState blockState = spawnerBlock.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(EntityType.DROWNED);
            spawner.update();
        }
        Block chestBlock = world.getBlockAt(x + 3, y, z + 2);
        chestBlock.setType(Material.CHEST);
        if (chestBlock.getState() instanceof Chest) {
            RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
        }
    }
}

