/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class SunkenShrine
extends RuinedStructures999.Structure {
    private final int width = 7;
    private final int length = 7;
    private final int height = 5;
    private final Random rand = new Random();

    public SunkenShrine(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            int y;
            Block block;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(10);
            int baseZ = chunk.getZ() * 16 + this.rand.nextInt(10);
            Biome biome = world.getBiome(baseX, 60, baseZ);
            if (this.getAllowedBiomes().isEmpty() || !this.getAllowedBiomes().contains(biome) || !(block = world.getBlockAt(baseX, y = world.getSeaLevel() - 5 - this.rand.nextInt(15), baseZ)).isLiquid()) continue;
            return new Location(world, (double)baseX, (double)y, (double)baseZ);
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                if (!(this.rand.nextDouble() < 0.8)) continue;
                Material floorMat = this.rand.nextDouble() < 0.7 ? Material.PRISMARINE_BRICKS : Material.STONE_BRICKS;
                world.getBlockAt(baseX + x, baseY - 1, baseZ + z).setType(floorMat, false);
            }
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    if (x != 0 && x != 6 && z != 0 && z != 6 || !(this.rand.nextDouble() < 0.4)) continue;
                    Material wallMat = this.rand.nextDouble() < 0.6 ? Material.PRISMARINE : Material.STONE_BRICKS;
                    world.getBlockAt(baseX + x, baseY + y, baseZ + z).setType(wallMat, false);
                }
            }
        }
        Block spawnerBlock = world.getBlockAt(baseX + 3, baseY, baseZ + 3);
        spawnerBlock.setType(Material.SPAWNER);
        BlockState blockState = spawnerBlock.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(EntityType.DROWNED);
            spawner.update();
        }
        Block chestBlock = world.getBlockAt(baseX + 1 + this.rand.nextInt(5), baseY, baseZ + 1 + this.rand.nextInt(5));
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
        }
    }
}

