/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class AbandonedFarmstead
extends RuinedStructures999.Structure {
    private final int footprintWidth = 15;
    private final int footprintLength = 15;
    private final int height = 6;
    private final Random rand = new Random();

    public AbandonedFarmstead(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(2);
            int highestY = world.getHighestBlockYAt(baseX + 7, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(2)) + 7);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, 15, 15) || !this.isAreaClear(world, baseX, highestY, baseZ, 15, 15, 6)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 6; ++y) {
                for (int z = 0; z < 15; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    block.setType(Material.AIR, false);
                }
            }
        }
        this.buildRuinedHouse(world, baseX + 1, baseY, baseZ + 1);
        this.buildCollapsedBarn(world, baseX + 15 - 8, baseY, baseZ + 15 - 10);
        this.buildScatteredFences(world, baseX, baseY, baseZ);
        if (this.rand.nextDouble() < 0.5) {
            this.buildScarecrow(world, baseX + 15 - 6, baseY, baseZ + 15 - 6);
        }
    }

    private void buildRuinedHouse(World world, int startX, int startY, int startZ) {
        int x;
        int width = 7;
        int length = 7;
        int houseHeight = 4;
        for (int x2 = 0; x2 < width; ++x2) {
            for (int z = 0; z < length; ++z) {
                Block floorBlock = world.getBlockAt(startX + x2, startY, startZ + z);
                double r = this.rand.nextDouble();
                if (r < 0.5) {
                    floorBlock.setType(Material.DIRT, false);
                    continue;
                }
                floorBlock.setType(Material.COARSE_DIRT, false);
            }
        }
        for (int y = 1; y < houseHeight; ++y) {
            for (x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    boolean isWall;
                    boolean bl = isWall = x == 0 || x == width - 1 || z == 0 || z == length - 1;
                    if (!isWall || this.rand.nextDouble() < 0.25) continue;
                    Block block = world.getBlockAt(startX + x, startY + y, startZ + z);
                    Material mat = this.rand.nextDouble() < 0.6 ? Material.OAK_PLANKS : Material.OAK_LOG;
                    block.setType(mat, false);
                }
            }
        }
        int roofY = startY + houseHeight;
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                if (this.rand.nextDouble() < 0.3) continue;
                Block block = world.getBlockAt(startX + x, roofY, startZ + z);
                double choice = this.rand.nextDouble();
                if (choice < 0.5) {
                    block.setType(Material.OAK_STAIRS, false);
                    Stairs stairs = (Stairs)block.getBlockData();
                    BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
                    stairs.setFacing(faces[this.rand.nextInt(faces.length)]);
                    block.setBlockData((BlockData)stairs, false);
                    continue;
                }
                block.setType(Material.OAK_SLAB, false);
            }
        }
        for (int y = 1; y < houseHeight; ++y) {
            for (int x3 = 0; x3 < width; ++x3) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(startX + x3, startY + y, startZ + z);
                    Material type = block.getType();
                    if ((type == Material.OAK_PLANKS || type == Material.OAK_LOG) && this.rand.nextDouble() < 0.1) {
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                            Block relative = block.getRelative(face);
                            if (relative.getType() != Material.AIR) continue;
                            relative.setType(Material.VINE, false);
                            break;
                        }
                    }
                    if (type != Material.AIR || !(this.rand.nextDouble() < 0.05)) continue;
                    block.setType(Material.COBWEB, false);
                }
            }
        }
        int chestX = startX + width / 2;
        int chestZ = startZ + length / 2;
        Block slabBlock = world.getBlockAt(chestX, startY + 1, chestZ);
        slabBlock.setType(Material.OAK_SLAB, false);
        Block chestBlock = world.getBlockAt(chestX, startY, chestZ);
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            Chest chest = (Chest)chestBlock.getState();
            this.fillChestLoot(chest);
            chest.update();
        }
    }

    private void buildCollapsedBarn(World world, int startX, int startY, int startZ) {
        int x;
        int width = 7;
        int length = 9;
        int barnHeight = 5;
        for (int x2 = 0; x2 < width; ++x2) {
            for (int z = 0; z < length; ++z) {
                Block floorBlock = world.getBlockAt(startX + x2, startY, startZ + z);
                double r = this.rand.nextDouble();
                if (r < 0.5) {
                    floorBlock.setType(Material.DIRT, false);
                    continue;
                }
                floorBlock.setType(Material.COARSE_DIRT, false);
            }
        }
        for (int y = 1; y < barnHeight; ++y) {
            for (x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    boolean isWall;
                    boolean bl = isWall = x == 0 || x == width - 1 || z == 0 || z == length - 1;
                    if (!isWall || this.rand.nextDouble() < 0.3) continue;
                    Block block = world.getBlockAt(startX + x, startY + y, startZ + z);
                    block.setType(Material.OAK_PLANKS, false);
                }
            }
        }
        int roofY = startY + barnHeight;
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                if (this.rand.nextDouble() < 0.4) continue;
                Block block = world.getBlockAt(startX + x, roofY, startZ + z);
                block.setType(Material.RED_WOOL, false);
            }
        }
        for (int i = 0; i < 3; ++i) {
            int hx = startX + 1 + this.rand.nextInt(width - 2);
            int hz = startZ + 1 + this.rand.nextInt(length - 2);
            int hy = startY + 1;
            int stackHeight = 1 + this.rand.nextInt(2);
            for (int h = 0; h < stackHeight; ++h) {
                Block hayBlock = world.getBlockAt(hx, hy + h, hz);
                hayBlock.setType(Material.HAY_BLOCK, false);
            }
        }
        int barrelCount = 2 + this.rand.nextInt(2);
        for (int i = 0; i < barrelCount; ++i) {
            int bx = startX + 1 + this.rand.nextInt(width - 2);
            int bz = startZ + 1 + this.rand.nextInt(length - 2);
            Block barrelBlock = world.getBlockAt(bx, startY + 1, bz);
            barrelBlock.setType(Material.BARREL, false);
            if (!(barrelBlock.getState() instanceof Barrel)) continue;
            Barrel barrel = (Barrel)barrelBlock.getState();
            barrel.getInventory().clear();
            this.fillBarrelLoot(barrel);
            barrel.update();
        }
    }

    private void buildScatteredFences(World world, int baseX, int baseY, int baseZ) {
        int fenceCount = 10 + this.rand.nextInt(6);
        for (int i = 0; i < fenceCount; ++i) {
            int fx = baseX + this.rand.nextInt(15);
            int fz = baseZ + this.rand.nextInt(15);
            int fy = baseY;
            Block block = world.getBlockAt(fx, fy, fz);
            if (this.rand.nextBoolean()) {
                block.setType(Material.OAK_FENCE, false);
            } else {
                block.setType(Material.OAK_FENCE_GATE, false);
            }
            if (!(this.rand.nextDouble() < 0.3)) continue;
            block.setType(Material.AIR, false);
        }
    }

    private void buildScarecrow(World world, int x, int y, int z) {
        Block baseBlock = world.getBlockAt(x, y, z);
        baseBlock.setType(Material.OAK_FENCE, false);
        Block arm1 = world.getBlockAt(x + 1, y + 1, z);
        arm1.setType(Material.OAK_FENCE_GATE, false);
        if (arm1.getBlockData() instanceof TrapDoor) {
            TrapDoor gate = (TrapDoor)arm1.getBlockData();
            gate.setOpen(true);
            arm1.setBlockData((BlockData)gate, false);
        }
        Block arm2 = world.getBlockAt(x - 1, y + 1, z);
        arm2.setType(Material.OAK_FENCE_GATE, false);
        if (arm2.getBlockData() instanceof TrapDoor) {
            TrapDoor gate = (TrapDoor)arm2.getBlockData();
            gate.setOpen(true);
            arm2.setBlockData((BlockData)gate, false);
        }
        Block headBlock = world.getBlockAt(x, y + 2, z);
        headBlock.setType(Material.CARVED_PUMPKIN, false);
    }

    private void fillBarrelLoot(Barrel barrel) {
        int amount;
        Random rand = new Random();
        if (rand.nextInt(100) < 70) {
            amount = 4 + rand.nextInt(6);
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WHEAT, amount)});
        }
        if (rand.nextInt(100) < 50) {
            amount = 2 + rand.nextInt(4);
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BREAD, amount)});
        }
        if (rand.nextInt(100) < 30) {
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_HOE, 1)});
        }
        if (rand.nextInt(100) < 40) {
            amount = 2 + rand.nextInt(5);
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CARROT, amount)});
        }
        if (rand.nextInt(100) < 50) {
            amount = 1 + rand.nextInt(3);
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.APPLE, amount)});
        }
    }
}

