/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.enchantments.Enchantment;

public class ForgottenBathhouse
extends RuinedStructures999.Structure {
    private final int minSize = 6;
    private final int maxSize = 8;
    private final Random rand = new Random();

    public ForgottenBathhouse(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        int size = 6 + this.rand.nextInt(3);
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(16 - size + 1);
            int highestY = world.getHighestBlockYAt(baseX + size / 2, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(16 - size + 1)) + size / 2);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, size, size) || !this.isAreaClear(world, baseX, highestY, baseZ, size, size, 5)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        int x;
        Block block;
        int z;
        World world = base.getWorld();
        int size = 6 + this.rand.nextInt(3);
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x2 = 0; x2 < size; ++x2) {
            for (int y = 0; y < 5; ++y) {
                for (z = 0; z < size; ++z) {
                    block = world.getBlockAt(baseX + x2, baseY + y, baseZ + z);
                    block.setType(Material.AIR, false);
                }
            }
        }
        for (int y = 0; y < 4; ++y) {
            for (x = 0; x < size; ++x) {
                for (z = 0; z < size; ++z) {
                    block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    if (y == 0) {
                        block.setType(Material.QUARTZ_BRICKS, false);
                        continue;
                    }
                    if (x == 0 || x == size - 1 || z == 0 || z == size - 1) {
                        if (this.rand.nextDouble() < 0.3) {
                            block.setType(Material.CRACKED_DEEPSLATE_BRICKS, false);
                            continue;
                        }
                        block.setType(Material.QUARTZ_BRICKS, false);
                        continue;
                    }
                    block.setType(Material.AIR, false);
                }
            }
        }
        for (int dx : new int[]{1, size - 3}) {
            int[] nArray = new int[]{1, size - 3};
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int dz = nArray[i];
                for (int x3 = dx; x3 < dx + 2; ++x3) {
                    for (int z2 = dz; z2 < dz + 2; ++z2) {
                        Block block2 = world.getBlockAt(baseX + x3, baseY + 1, baseZ + z2);
                        block2.setType(Material.WATER, false);
                    }
                }
            }
        }
        for (int dx : new int[]{0, size - 1}) {
            for (int dz = 0; dz < size; ++dz) {
                Block block3 = world.getBlockAt(baseX + dx, baseY + 1, baseZ + dz);
                block3.setType(Material.STONE_SLAB, false);
            }
        }
        int[] y = new int[]{0, size - 1};
        x = y.length;
        for (z = 0; z < x; ++z) {
            int dz = y[z];
            for (int dx = 0; dx < size; ++dx) {
                Block block4 = world.getBlockAt(baseX + dx, baseY + 1, baseZ + dz);
                block4.setType(Material.STONE_SLAB, false);
            }
        }
        for (int i = 0; i < 4; ++i) {
            x = baseX + (i % 2 == 0 ? 1 : size - 2);
            z = baseZ + (i < 2 ? 1 : size - 2);
            Block block5 = world.getBlockAt(x, baseY + 2, z);
            block5.setType(Material.LANTERN, false);
            if (!(block5.getBlockData() instanceof Lantern)) continue;
            Lantern lantern = (Lantern)block5.getBlockData();
            lantern.setHanging(true);
            block5.setBlockData((BlockData)lantern, false);
        }
        for (int y2 = 1; y2 < 4; ++y2) {
            for (x = 0; x < size; ++x) {
                for (z = 0; z < size; ++z) {
                    Block block6 = world.getBlockAt(baseX + x, baseY + y2, baseZ + z);
                    if (block6.getType() == Material.QUARTZ_BRICKS && this.rand.nextDouble() < 0.1) {
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                            Block relative = block6.getRelative(face);
                            if (relative.getType() != Material.AIR) continue;
                            relative.setType(Material.VINE, false);
                            break;
                        }
                    }
                    if (block6.getType() != Material.AIR || !(this.rand.nextDouble() < 0.05)) continue;
                    block6.setType(Material.MOSS_BLOCK, false);
                }
            }
        }
        Block chestBlock = world.getBlockAt(baseX + size / 2, baseY + 1, baseZ + size / 2);
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            Chest chest = (Chest)chestBlock.getState();
            this.fillChestLoot(chest);
            chest.update();
        }
    }
}

