/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Furnace;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class House
extends RuinedStructures999.Structure {
    private final int width = 6;
    private final int length = 6;
    private final int height = 4;

    public House(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + new Random().nextInt(11);
            int highestY = world.getHighestBlockYAt(baseX + 3, (baseZ = chunk.getZ() * 16 + new Random().nextInt(11)) + 3);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, 6, 6) || !this.isAreaClear(world, baseX, highestY, baseZ, 6, 6, 4)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        Block block;
        int x;
        int z;
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        Random rand = new Random();
        for (int x2 = 0; x2 < 6; ++x2) {
            for (int y = 0; y < 4; ++y) {
                for (z = 0; z < 6; ++z) {
                    Block block2 = world.getBlockAt(baseX + x2, baseY + y, baseZ + z);
                    block2.setType(Material.AIR, false);
                }
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 6; ++x) {
                for (z = 0; z < 6; ++z) {
                    boolean isWall;
                    boolean bl = isWall = x == 0 || x == 5 || z == 0 || z == 5;
                    if (!isWall) continue;
                    block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material mat = rand.nextDouble() < 0.3 ? Material.MOSSY_COBBLESTONE : Material.COBBLESTONE;
                    block.setType(mat, false);
                }
            }
        }
        int floorY = baseY;
        for (x = 1; x < 5; ++x) {
            for (z = 1; z < 5; ++z) {
                if (rand.nextDouble() < 0.3) continue;
                Block block3 = world.getBlockAt(baseX + x, floorY, baseZ + z);
                block3.setType(Material.OAK_SLAB, false);
            }
        }
        int roofY = baseY + 4 - 1;
        for (int x3 = 0; x3 < 6; ++x3) {
            for (int z2 = 0; z2 < 6; ++z2) {
                if (rand.nextDouble() < 0.25) continue;
                block = world.getBlockAt(baseX + x3, roofY, baseZ + z2);
                double choice = rand.nextDouble();
                if (choice < 0.5) {
                    block.setType(Material.OAK_PLANKS, false);
                    continue;
                }
                if (choice < 0.75) {
                    block.setType(Material.OAK_SLAB, false);
                    continue;
                }
                block.setType(Material.OAK_STAIRS, false);
                BlockFace[] stairs = (BlockFace[])block.getBlockData();
                BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
                stairs.setFacing(faces[rand.nextInt(faces.length)]);
                block.setBlockData((BlockData)stairs, false);
            }
        }
        for (int y = 1; y < 3; ++y) {
            for (int x4 = 0; x4 < 6; ++x4) {
                for (int z3 = 0; z3 < 6; ++z3) {
                    Block block4 = world.getBlockAt(baseX + x4, baseY + y, baseZ + z3);
                    Material type = block4.getType();
                    if ((type == Material.COBBLESTONE || type == Material.MOSSY_COBBLESTONE) && rand.nextDouble() < 0.1) {
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                            Block relative = block4.getRelative(face);
                            if (relative.getType() != Material.AIR) continue;
                            relative.setType(Material.VINE, false);
                            break;
                        }
                    }
                    if (type != Material.AIR || !(rand.nextDouble() < 0.05)) continue;
                    block4.setType(Material.COBWEB, false);
                }
            }
        }
        int furnaceX = baseX + 1;
        int furnaceZ = baseZ + 1;
        Block furnaceBlock = world.getBlockAt(furnaceX, baseY, furnaceZ);
        furnaceBlock.setType(Material.FURNACE, false);
        if (furnaceBlock.getState() instanceof Furnace) {
            Furnace furnace = (Furnace)furnaceBlock.getState();
            furnace.getInventory().clear();
            int ironNuggets = 1 + rand.nextInt(3);
            furnace.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_NUGGET, ironNuggets)});
            furnace.update();
        }
        int chestX = baseX + 3;
        int chestZ = baseZ + 3;
        Block chestBlock = world.getBlockAt(chestX, floorY, chestZ);
        chestBlock.setType(Material.OAK_SLAB, false);
        Block chestBelow = world.getBlockAt(chestX, floorY - 1, chestZ);
        chestBelow.setType(Material.CHEST, false);
        if (chestBelow.getState() instanceof Chest) {
            Chest chest = (Chest)chestBelow.getState();
            this.fillChestLoot(chest);
            chest.update();
        }
    }
}

