/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Piglin;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PiglinVillage
extends RuinedStructures999.Structure {
    private static final int MIN_HOUSES = 4;
    private static final int MAX_HOUSES = 9;
    private static final int HOUSE_FOOTPRINT = 5;
    private static final int HOUSE_HEIGHT = 4;
    private static final int MIN_DISTANCE_BETWEEN_HOUSES = 5;
    private final Random rand = new Random();

    public PiglinVillage(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        int baseZ;
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NETHER) {
            return null;
        }
        Biome biome = chunk.getBlock(8, world.getHighestBlockYAt(chunk.getX() * 16 + 8, chunk.getZ() * 16 + 8), 8).getBiome();
        if (!this.allowedBiomes.isEmpty() && !this.allowedBiomes.contains(biome)) {
            return null;
        }
        int baseX = chunk.getX() * 16;
        int baseY = world.getHighestBlockYAt(baseX + 8, (baseZ = chunk.getZ() * 16) + 8);
        if (baseY < 1) {
            return null;
        }
        Location base = new Location(world, (double)baseX, (double)baseY, (double)baseZ);
        return base;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int chunkX = base.getBlockX();
        int chunkZ = base.getBlockZ();
        int houseCount = 4 + this.rand.nextInt(6);
        List<Location> houseLocations = this.generateHousePositions(world, chunkX, chunkZ, houseCount);
        for (Location houseLoc : houseLocations) {
            this.buildHouse(world, houseLoc);
        }
        this.buildPaths(world, houseLocations);
        for (Location houseLoc : houseLocations) {
            this.placeCampfire(world, houseLoc);
        }
    }

    private List<Location> generateHousePositions(World world, int chunkX, int chunkZ, int count) {
        ArrayList<Location> positions = new ArrayList<Location>();
        int attempts = 0;
        while (positions.size() < count && attempts < 100) {
            int z;
            ++attempts;
            int x = chunkX + 2 + this.rand.nextInt(7);
            int y = world.getHighestBlockYAt(x + 2, (z = chunkZ + 2 + this.rand.nextInt(7)) + 2);
            if (y < 1) continue;
            Location candidate = new Location(world, (double)x, (double)y, (double)z);
            boolean tooClose = false;
            for (Location loc : positions) {
                if (!(loc.distanceSquared(candidate) < 25.0)) continue;
                tooClose = true;
                break;
            }
            if (tooClose) continue;
            positions.add(candidate);
        }
        return positions;
    }

    private void buildHouse(World world, Location base) {
        int x;
        int x2;
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (x2 = 0; x2 < 5; ++x2) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 5; ++z) {
                    Block block = world.getBlockAt(baseX + x2, baseY + y, baseZ + z);
                    block.setType(Material.AIR, false);
                }
            }
        }
        for (x2 = 0; x2 < 5; ++x2) {
            for (int z = 0; z < 5; ++z) {
                Block floorBlock = world.getBlockAt(baseX + x2, baseY, baseZ + z);
                floorBlock.setType(this.rand.nextDouble() < 0.7 ? Material.BLACKSTONE : Material.SOUL_SAND, false);
            }
        }
        for (int y = 1; y < 4; ++y) {
            for (x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    boolean isWall;
                    boolean bl = isWall = x == 0 || x == 4 || z == 0 || z == 4;
                    if (!isWall) continue;
                    double r = this.rand.nextDouble();
                    Material mat = r < 0.5 ? Material.NETHER_BRICKS : (r < 0.8 ? Material.BLACKSTONE : Material.CRACKED_NETHER_BRICKS);
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    block.setType(mat, false);
                }
            }
        }
        int roofY = baseY + 4;
        for (x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                Block block = world.getBlockAt(baseX + x, roofY, baseZ + z);
                if (this.rand.nextDouble() < 0.5) {
                    block.setType(Material.BLACKSTONE_SLAB, false);
                    if (!(block.getBlockData() instanceof Slab)) continue;
                    Slab slab = (Slab)block.getBlockData();
                    slab.setType(Slab.Type.TOP);
                    block.setBlockData((BlockData)slab, false);
                    continue;
                }
                block.setType(Material.BLACKSTONE_STAIRS, false);
                if (!(block.getBlockData() instanceof Stairs)) continue;
                Stairs stairs = (Stairs)block.getBlockData();
                BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
                stairs.setFacing(faces[this.rand.nextInt(faces.length)]);
                block.setBlockData((BlockData)stairs, false);
            }
        }
        Block gold1 = world.getBlockAt(baseX + 1, baseY + 1, baseZ + 1);
        gold1.setType(Material.GOLD_BLOCK, false);
        Block gold2 = world.getBlockAt(baseX + 5 - 2, baseY + 1, baseZ + 5 - 2);
        gold2.setType(Material.GOLD_BLOCK, false);
        Block chestBlock = world.getBlockAt(baseX + 2, baseY + 1, baseZ + 2);
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            Chest chest = (Chest)chestBlock.getState();
            this.fillChestLoot(chest);
            chest.update();
        }
        for (int i = 0; i < 2; ++i) {
            double offsetX = 1.5 + (double)i;
            double offsetZ = 2.5;
            Location piglinLoc = new Location(world, (double)baseX + offsetX, (double)(baseY + 1), (double)baseZ + offsetZ);
            Piglin piglin = (Piglin)world.spawnEntity(piglinLoc, EntityType.PIGLIN);
            piglin.setPersistent(true);
            piglin.setAdult();
            piglin.setCustomName("Piglin Guard");
            piglin.setCustomNameVisible(false);
        }
    }

    private void buildPaths(World world, List<Location> houses) {
        if (houses.isEmpty()) {
            return;
        }
        Location center = houses.get(0);
        for (int i = 1; i < houses.size(); ++i) {
            Location target = houses.get(i);
            this.buildPath(world, center, target);
        }
    }

    private void buildPath(World world, Location start, Location end) {
        int x1 = start.getBlockX() + 2;
        int z1 = start.getBlockZ() + 2;
        int x2 = end.getBlockX() + 2;
        int z2 = end.getBlockZ() + 2;
        int y = start.getBlockY();
        int currentX = x1;
        int currentZ = z1;
        while (currentX != x2 || currentZ != z2) {
            if (currentX != x2) {
                currentX += x2 > currentX ? 1 : -1;
            } else if (currentZ != z2) {
                currentZ += z2 > currentZ ? 1 : -1;
            }
            int width = this.rand.nextBoolean() ? 1 : 2;
            for (int dx = 0; dx < width; ++dx) {
                for (int dz = 0; dz < width; ++dz) {
                    Block block = world.getBlockAt(currentX + dx, y, currentZ + dz);
                    block.setType(Material.POLISHED_BLACKSTONE_BRICKS, false);
                }
            }
        }
    }

    private void placeCampfire(World world, Location houseLoc) {
        int baseX = houseLoc.getBlockX();
        int baseY = houseLoc.getBlockY();
        int baseZ = houseLoc.getBlockZ();
        int campfireX = baseX + 2;
        int campfireZ = baseZ + 5;
        Block campfireBlock = world.getBlockAt(campfireX, baseY + 1, campfireZ);
        campfireBlock.setType(Material.SOUL_CAMPFIRE, false);
        if (this.rand.nextDouble() < 0.5) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dz == 0) continue;
                    Block block = world.getBlockAt(campfireX + dx, baseY + 1, campfireZ + dz);
                    if (this.rand.nextBoolean()) {
                        block.setType(Material.NETHER_BRICKS, false);
                        continue;
                    }
                    block.setType(Material.NETHER_BRICK_FENCE, false);
                }
            }
        }
    }

    @Override
    protected void fillChestLoot(Chest chest) {
        int amount;
        if (this.rand.nextInt(100) < 70) {
            amount = 5 + this.rand.nextInt(11);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLD_NUGGET, amount)});
        }
        if (this.rand.nextInt(100) < 50) {
            amount = 1 + this.rand.nextInt(3);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLD_INGOT, amount)});
        }
        if (this.rand.nextInt(100) < 60) {
            amount = 3 + this.rand.nextInt(6);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.NETHER_WART, amount)});
        }
        if (this.rand.nextInt(100) < 30) {
            amount = 1 + this.rand.nextInt(2);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BLAZE_ROD, amount)});
        }
        if (this.rand.nextInt(100) < 50) {
            amount = 4 + this.rand.nextInt(7);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SOUL_SAND, amount)});
        }
        if (this.rand.nextInt(100) < 40) {
            amount = 2 + this.rand.nextInt(5);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GLOWSTONE_DUST, amount)});
        }
        if (this.rand.nextInt(100) < 40) {
            amount = 1 + this.rand.nextInt(3);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WARPED_FUNGUS, amount)});
        }
        if (this.rand.nextInt(100) < 40) {
            amount = 1 + this.rand.nextInt(3);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CRIMSON_FUNGUS, amount)});
        }
        if (this.rand.nextInt(100) < 50) {
            amount = 2 + this.rand.nextInt(4);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.QUARTZ_BLOCK, amount)});
        }
        if (this.rand.nextInt(100) < 30) {
            amount = 1 + this.rand.nextInt(3);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.OBSIDIAN, amount)});
        }
        if (this.rand.nextInt(100) < 5) {
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ANCIENT_DEBRIS, 1)});
        }
        if (this.rand.nextInt(100) < 25) {
            amount = 1 + this.rand.nextInt(2);
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MAGMA_CREAM, amount)});
        }
        if (this.rand.nextInt(100) < 10) {
            chest.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SADDLE, 1)});
        }
        if (this.rand.nextInt(100) < 5) {
            ItemStack piglinHead = new ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta meta = (SkullMeta)piglinHead.getItemMeta();
            if (meta != null) {
                meta.setOwner("Piglin");
                piglinHead.setItemMeta((ItemMeta)meta);
            }
            chest.getInventory().addItem(new ItemStack[]{piglinHead});
        }
    }
}

