/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class RuinedCamp
extends RuinedStructures999.Structure {
    private final int footprintSize = 12;
    private final Random rand = new Random();

    public RuinedCamp(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(5);
            int highestY = world.getHighestBlockYAt(baseX + 6, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(5)) + 6);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, 12, 12) || !this.isAreaClear(world, baseX, highestY, baseZ, 12, 12, 5)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x = 0; x < 12; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 12; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    block.setType(Material.AIR, false);
                }
            }
        }
        int campCount = 2 + this.rand.nextInt(2);
        ArrayList<Location> campCenters = new ArrayList<Location>();
        for (int i = 0; i < campCount; ++i) {
            int cx = baseX + 2 + this.rand.nextInt(8);
            int cz = baseZ + 2 + this.rand.nextInt(8);
            campCenters.add(new Location(world, (double)cx, (double)baseY, (double)cz));
        }
        for (Location campCenter : campCenters) {
            int type = this.rand.nextInt(3);
            switch (type) {
                case 0: {
                    this.buildBrokenTent(campCenter);
                    break;
                }
                case 1: {
                    this.buildExtinguishedCampfire(campCenter);
                    break;
                }
                case 2: {
                    this.buildGuardSpot(campCenter);
                }
            }
        }
    }

    private void buildBrokenTent(Location center) {
        int y;
        World world = center.getWorld();
        int cx = center.getBlockX();
        int cy = center.getBlockY();
        int cz = center.getBlockZ();
        Random rand = new Random();
        int tentWidth = 5;
        int tentLength = 5;
        int tentHeight = 3;
        for (int x = -tentWidth / 2; x <= tentWidth / 2; ++x) {
            for (int z = -tentLength / 2; z <= tentLength / 2; ++z) {
                Block groundBlock = world.getBlockAt(cx + x, cy - 1, cz + z);
                double r = rand.nextDouble();
                if (r < 0.4) {
                    groundBlock.setType(Material.DIRT, false);
                    continue;
                }
                if (r < 0.7) {
                    groundBlock.setType(Material.COARSE_DIRT, false);
                    continue;
                }
                groundBlock.setType(Material.GRASS_BLOCK, false);
            }
        }
        int[] supportX = new int[]{-tentWidth / 2, tentWidth / 2};
        int[] supportZ = new int[]{-tentLength / 2, tentLength / 2};
        for (y = 0; y < tentHeight; ++y) {
            for (int x : supportX) {
                for (int z : supportZ) {
                    Block supportBlock = world.getBlockAt(cx + x, cy + y, cz + z);
                    supportBlock.setType(Material.STRIPPED_OAK_LOG, false);
                }
            }
        }
        for (y = 1; y < tentHeight; ++y) {
            for (int x = -tentWidth / 2 + 1; x <= tentWidth / 2 - 1; ++x) {
                for (int z = -tentLength / 2 + 1; z <= tentLength / 2 - 1; ++z) {
                    if (rand.nextDouble() < 0.3) continue;
                    Block woolBlock = world.getBlockAt(cx + x, cy + y, cz + z);
                    woolBlock.setType(Material.WHITE_WOOL, false);
                }
            }
        }
        Block chestBlock = world.getBlockAt(cx, cy, cz);
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            Chest chest = (Chest)chestBlock.getState();
            chest.getBlockInventory().clear();
            this.addItemWithChance(chest, Material.BREAD, 2, 6, 50);
            this.addItemWithChance(chest, Material.COOKED_PORKCHOP, 1, 4, 40);
            this.addItemWithChance(chest, Material.COOKED_MUTTON, 1, 4, 40);
            this.addItemWithChance(chest, Material.COOKED_BEEF, 1, 4, 40);
            this.addItemWithChance(chest, Material.COOKED_CHICKEN, 1, 4, 40);
            this.addItemWithChance(chest, Material.COOKED_COD, 1, 4, 40);
            this.addItemWithChance(chest, Material.PUMPKIN_PIE, 1, 2, 30);
            chest.update();
        }
    }

    private void addItemWithChance(Chest chest, Material mat, int min, int max, int chancePercent) {
        Random rand = new Random();
        if (rand.nextInt(100) < chancePercent) {
            int amount = min + rand.nextInt(max - min + 1);
            chest.getBlockInventory().addItem(new ItemStack[]{new ItemStack(mat, amount)});
        }
    }

    private void buildExtinguishedCampfire(Location center) {
        World world = center.getWorld();
        int cx = center.getBlockX();
        int cy = center.getBlockY();
        int cz = center.getBlockZ();
        Block hayBlock = world.getBlockAt(cx, cy - 1, cz);
        hayBlock.setType(Material.HAY_BLOCK, false);
        Block campfireBlock = world.getBlockAt(cx, cy, cz);
        campfireBlock.setType(Material.CAMPFIRE, false);
        int[][] offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};
        Random rand = new Random();
        for (int[] offset : offsets) {
            if (rand.nextDouble() < 0.3) continue;
            Block benchBlock = world.getBlockAt(cx + offset[0], cy, cz + offset[1]);
            benchBlock.setType(Material.STRIPPED_OAK_LOG, false);
        }
    }

    private void buildGuardSpot(Location center) {
        World world = center.getWorld();
        int cx = center.getBlockX();
        int cy = center.getBlockY();
        int cz = center.getBlockZ();
        Block fenceBlock = world.getBlockAt(cx, cy, cz);
        fenceBlock.setType(Material.OAK_FENCE, false);
        Block chainBlock = world.getBlockAt(cx, cy + 1, cz);
        chainBlock.setType(Material.CHAIN, false);
        Block lanternBlock = world.getBlockAt(cx, cy + 2, cz);
        lanternBlock.setType(Material.LANTERN, false);
        if (lanternBlock.getBlockData() instanceof Lantern) {
            Lantern lantern = (Lantern)lanternBlock.getBlockData();
            lantern.setHanging(true);
            lanternBlock.setBlockData((BlockData)lantern, false);
        }
        Block skullBlock = world.getBlockAt(cx + 1, cy, cz);
        skullBlock.setType(Material.SKELETON_SKULL, false);
    }
}

