/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.AbandonedFarmstead;
import com.yourname.ruinedstructures999.House;
import com.yourname.ruinedstructures999.PiglinVillage;
import com.yourname.ruinedstructures999.RuinedCamp;
import com.yourname.ruinedstructures999.WatchTower;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Chest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class RuinedStructures999
extends JavaPlugin
implements Listener,
TabCompleter {
    private FileConfiguration config;
    private final Map<String, Structure> structures = new HashMap<String, Structure>();
    private boolean spawningEnabled = false;
    private Random random;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadPluginConfig();
        this.getCommand("RuinedStructures999").setExecutor((sender, command, label, args) -> {
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    this.reloadPluginConfig();
                    sender.sendMessage("RuinedStructures999 config reloaded.");
                    return true;
                }
                if (args[0].equalsIgnoreCase("initialize")) {
                    this.spawningEnabled = true;
                    sender.sendMessage("RuinedStructures999 structure spawning enabled on new chunks.");
                    return true;
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("spawn")) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("Only players can use this command.");
                    return true;
                }
                final Player player = (Player)sender;
                final String structName = args[1].toLowerCase(Locale.ROOT);
                final Structure structure = this.structures.get(structName);
                if (structure == null) {
                    sender.sendMessage("Structure '" + args[1] + "' not found or not enabled.");
                    return true;
                }
                Location loc = player.getLocation().getBlock().getLocation();
                int groundY = loc.getWorld().getHighestBlockYAt(loc);
                final Location spawnLoc = new Location(loc.getWorld(), (double)loc.getBlockX(), (double)groundY, (double)loc.getBlockZ());
                new BukkitRunnable(){

                    public void run() {
                        structure.generate(spawnLoc);
                        player.sendMessage("Spawned structure '" + structName + "' at your location.");
                    }
                }.runTask((Plugin)this);
                return true;
            }
            sender.sendMessage("Usage:");
            sender.sendMessage("/ruinedstructures999 reload - Reload config");
            sender.sendMessage("/ruinedstructures999 initialize - Enable spawning on new chunks");
            sender.sendMessage("/ruinedstructures999 spawn <structureName> - Spawn structure at your location");
            return true;
        });
        this.getCommand("RuinedStructures999").setTabCompleter((TabCompleter)this);
        this.getCommand("rs999").setExecutor(this.getCommand("RuinedStructures999").getExecutor());
        this.getCommand("rs999").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("RuinedStructures999 enabled.");
    }

    public void onDisable() {
        this.getLogger().info("RuinedStructures999 disabled.");
    }

    private void reloadPluginConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.random = new Random();
        this.structures.clear();
        ConfigurationSection structuresSection = this.config.getConfigurationSection("structures");
        if (structuresSection == null) {
            this.getLogger().warning("No 'structures' section found in config.yml");
            return;
        }
        for (String key : structuresSection.getKeys(false)) {
            Structure structure;
            boolean enabled;
            ConfigurationSection structSection = structuresSection.getConfigurationSection(key);
            if (structSection == null || !(enabled = structSection.getBoolean("enabled", false))) continue;
            double spawnChance = structSection.getDouble("spawn-chance-per-chunk", 0.2);
            List allowedBiomesStr = structSection.getStringList("allowed-biomes");
            HashSet<Biome> allowedBiomes = new HashSet<Biome>();
            for (String biomeName : allowedBiomesStr) {
                try {
                    Biome biome = Biome.valueOf((String)biomeName.toUpperCase(Locale.ROOT));
                    allowedBiomes.add(biome);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid biome name in config for structure " + key + ": " + biomeName);
                }
            }
            ArrayList<LootEntry> lootEntries = new ArrayList<LootEntry>();
            List lootList = structSection.getMapList("chest_loot");
            if (lootList != null) {
                for (Map map : lootList) {
                    LootEntry entry = LootEntry.fromMap(map);
                    if (entry == null) continue;
                    lootEntries.add(entry);
                }
            }
            HashMap<Enchantment, IntRange> allowedEnchantments = new HashMap<Enchantment, IntRange>();
            ConfigurationSection enchSection = structSection.getConfigurationSection("enchantments");
            if (enchSection != null) {
                for (String enchKey : enchSection.getKeys(false)) {
                    String rangeStr = enchSection.getString(enchKey);
                    IntRange range = IntRange.parse(rangeStr);
                    Enchantment ench = this.getEnchantmentByName(enchKey);
                    if (ench == null || range == null) continue;
                    allowedEnchantments.put(ench, range);
                }
            }
            if ("collapsed_watchtower".equalsIgnoreCase(key)) {
                structure = new WatchTower(key, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
                this.structures.put(key.toLowerCase(Locale.ROOT), structure);
                continue;
            }
            if ("ruined_house".equalsIgnoreCase(key)) {
                structure = new House(key, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
                this.structures.put(key.toLowerCase(Locale.ROOT), structure);
                continue;
            }
            if ("ruined_camp".equalsIgnoreCase(key)) {
                structure = new RuinedCamp(key, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
                this.structures.put(key.toLowerCase(Locale.ROOT), structure);
                continue;
            }
            if ("abandoned_farmstead".equalsIgnoreCase(key)) {
                structure = new AbandonedFarmstead(key, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
                this.structures.put(key.toLowerCase(Locale.ROOT), structure);
                continue;
            }
            if ("piglin_village".equalsIgnoreCase(key)) {
                structure = new PiglinVillage(key, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
                this.structures.put(key.toLowerCase(Locale.ROOT), structure);
                continue;
            }
            this.getLogger().warning("Unknown structure key in config: " + key);
        }
    }

    private Enchantment getEnchantmentByName(String name) {
        try {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase(Locale.ROOT)));
        }
        catch (Exception e) {
            return Enchantment.getByName((String)name.toUpperCase(Locale.ROOT));
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.spawningEnabled) {
            return;
        }
        if (!event.isNewChunk()) {
            return;
        }
        Chunk chunk = event.getChunk();
        World world = chunk.getWorld();
        for (Structure structure : this.structures.values()) {
            Location spawnLoc;
            Biome biome;
            if (!structure.isEnabled() || !structure.isBiomeAllowed(biome = chunk.getBlock(8, world.getHighestBlockYAt(chunk.getBlock(8, 0, 8).getLocation()), 8).getBiome()) || this.random.nextDouble() > structure.getSpawnChance() || (spawnLoc = structure.findValidSpawnLocation(chunk)) == null) continue;
            structure.generate(spawnLoc);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if ("reload".startsWith(args[0].toLowerCase(Locale.ROOT))) {
                completions.add("reload");
            }
            if ("initialize".startsWith(args[0].toLowerCase(Locale.ROOT))) {
                completions.add("initialize");
            }
            if ("spawn".startsWith(args[0].toLowerCase(Locale.ROOT))) {
                completions.add("spawn");
            }
            return completions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("spawn")) {
            String partial = args[1].toLowerCase(Locale.ROOT);
            return this.structures.keySet().stream().filter(s -> s.startsWith(partial)).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static class LootEntry {
        public final Material material;
        public final IntRange amount;
        public final int chance;

        public LootEntry(Material material, IntRange amount, int chance) {
            this.material = material;
            this.amount = amount;
            this.chance = chance;
        }

        public static LootEntry fromMap(Map<?, ?> map) {
            if (map == null) {
                return null;
            }
            Object itemObj = map.get("item");
            Object amountObj = map.get("amount");
            Object chanceObj = map.get("chance");
            if (!(itemObj instanceof String)) {
                return null;
            }
            if (!(amountObj instanceof String)) {
                return null;
            }
            if (!(chanceObj instanceof Number)) {
                return null;
            }
            Material mat = Material.matchMaterial((String)((String)itemObj).toUpperCase(Locale.ROOT));
            if (mat == null) {
                return null;
            }
            IntRange amountRange = IntRange.parse((String)amountObj);
            if (amountRange == null) {
                return null;
            }
            int chance = ((Number)chanceObj).intValue();
            if (chance < 0) {
                chance = 0;
            }
            if (chance > 100) {
                chance = 100;
            }
            return new LootEntry(mat, amountRange, chance);
        }
    }

    public static class IntRange {
        public final int min;
        public final int max;

        public IntRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getRandom(Random rand) {
            if (this.max <= this.min) {
                return this.min;
            }
            return this.min + rand.nextInt(this.max - this.min + 1);
        }

        public static IntRange parse(String s) {
            if (s == null) {
                return null;
            }
            if ((s = s.trim()).contains("-")) {
                String[] parts = s.split("-");
                if (parts.length != 2) {
                    return null;
                }
                try {
                    int min = Integer.parseInt(parts[0].trim());
                    int max = Integer.parseInt(parts[1].trim());
                    if (min > max) {
                        return null;
                    }
                    return new IntRange(min, max);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            try {
                int val = Integer.parseInt(s);
                return new IntRange(val, val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static abstract class Structure {
        protected final String name;
        protected final double spawnChance;
        protected final Set<Biome> allowedBiomes;
        protected final List<LootEntry> lootEntries;
        protected final Map<Enchantment, IntRange> allowedEnchantments;
        protected boolean enabled = true;

        public Structure(String name, double spawnChance, Set<Biome> allowedBiomes, List<LootEntry> lootEntries, Map<Enchantment, IntRange> allowedEnchantments) {
            this.name = name;
            this.spawnChance = spawnChance;
            this.allowedBiomes = allowedBiomes;
            this.lootEntries = lootEntries;
            this.allowedEnchantments = allowedEnchantments;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public double getSpawnChance() {
            return this.spawnChance;
        }

        public boolean isBiomeAllowed(Biome biome) {
            if (this.allowedBiomes.isEmpty()) {
                return true;
            }
            return this.allowedBiomes.contains(biome);
        }

        public abstract Location findValidSpawnLocation(Chunk var1);

        public abstract void generate(Location var1);

        protected void fillChestLoot(Chest chest) {
            if (this.lootEntries.isEmpty()) {
                return;
            }
            chest.getBlockInventory().clear();
            Random rand = new Random();
            for (LootEntry entry : this.lootEntries) {
                Material mat;
                int amount;
                if (rand.nextInt(100) >= entry.chance || (amount = entry.amount.getRandom(rand)) <= 0 || (mat = entry.material) == null) continue;
                if (mat == Material.ENCHANTED_BOOK) {
                    for (int i = 0; i < amount; ++i) {
                        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
                        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
                        int enchCount = 1 + rand.nextInt(2);
                        ArrayList<Enchantment> enchList = new ArrayList<Enchantment>(this.allowedEnchantments.keySet());
                        Collections.shuffle(enchList, rand);
                        int added = 0;
                        for (Enchantment ench : enchList) {
                            if (added >= enchCount) break;
                            IntRange range = this.allowedEnchantments.get(ench);
                            int level = range.getRandom(rand);
                            if (level <= 0) continue;
                            meta.addStoredEnchant(ench, level, true);
                            ++added;
                        }
                        book.setItemMeta((ItemMeta)meta);
                        chest.getBlockInventory().addItem(new ItemStack[]{book});
                    }
                    continue;
                }
                ItemStack itemStack = new ItemStack(mat, amount);
                chest.getBlockInventory().addItem(new ItemStack[]{itemStack});
            }
        }
    }
}

