/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Furnace;
import org.bukkit.enchantments.Enchantment;

public class Stonecut_Shelter
extends RuinedStructures999.Structure {
    private final int width = 4;
    private final int length = 4;
    private final int height = 4;
    private final Random rand = new Random();

    public Stonecut_Shelter(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(13);
            int highestY = world.getHighestBlockYAt(baseX + 2, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(13)) + 2);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, 4, 4)) continue;
            boolean cliffSide = true;
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    Block behind = world.getBlockAt(baseX + x, highestY + y, baseZ - 1);
                    if (behind.getType().isSolid()) continue;
                    cliffSide = false;
                    break;
                }
                if (!cliffSide) break;
            }
            if (!cliffSide || !this.isAreaClear(world, baseX, highestY, baseZ, 4, 4, 4)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        int x;
        Block block;
        int z;
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x2 = 0; x2 < 4; ++x2) {
            for (int y = 0; y < 4; ++y) {
                for (z = 0; z < 4; ++z) {
                    block = world.getBlockAt(baseX + x2, baseY + y, baseZ + z);
                    block.setType(Material.AIR, false);
                }
            }
        }
        for (int y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                for (z = 0; z < 4; ++z) {
                    block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    if (y == 0) {
                        block.setType(this.rand.nextDouble() < 0.5 ? Material.COBBLESTONE : Material.STONE_BRICKS, false);
                        continue;
                    }
                    if (z == 0) continue;
                    if (x == 0 || x == 3 || z == 3) {
                        double r = this.rand.nextDouble();
                        if (r < 0.4) {
                            block.setType(Material.COBBLESTONE, false);
                            continue;
                        }
                        if (r < 0.7) {
                            block.setType(Material.STONE_BRICKS, false);
                            continue;
                        }
                        block.setType(Material.ANDESITE, false);
                        continue;
                    }
                    block.setType(Material.AIR, false);
                }
            }
        }
        int roofY = baseY + 4;
        for (x = 0; x < 4; ++x) {
            for (z = 1; z < 4; ++z) {
                block = world.getBlockAt(baseX + x, roofY, baseZ + z);
                if (this.rand.nextDouble() < 0.3) {
                    block.setType(Material.STONE_BRICK_SLAB, false);
                    continue;
                }
                block.setType(Material.STONE_BRICKS, false);
            }
        }
        Block stonecutterBlock = world.getBlockAt(baseX + 2, baseY + 1, baseZ + 2);
        stonecutterBlock.setType(Material.STONECUTTER, false);
        Block furnaceBlock = world.getBlockAt(baseX + 2 - 1, baseY + 1, baseZ + 2);
        furnaceBlock.setType(Material.FURNACE, false);
        if (furnaceBlock.getState() instanceof Furnace) {
            Furnace furnace = (Furnace)furnaceBlock.getState();
            furnace.getInventory().clear();
            furnace.update();
        }
        Block chestBlock = world.getBlockAt(baseX + 2, baseY + 1, baseZ + 2 - 1);
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            Chest chest = (Chest)chestBlock.getState();
            this.fillChestLoot(chest);
            chest.update();
        }
        for (int i = 0; i < 3; ++i) {
            int cz;
            int cy;
            int cx = baseX + 1 + this.rand.nextInt(2);
            Block block2 = world.getBlockAt(cx, cy = baseY + 1 + this.rand.nextInt(2), cz = baseZ + 1 + this.rand.nextInt(2));
            if (block2.getType() != Material.AIR) continue;
            block2.setType(Material.COBWEB, false);
        }
        for (int y = 1; y < 4; ++y) {
            for (int x3 = 0; x3 < 4; ++x3) {
                block11: for (int z2 = 1; z2 < 4; ++z2) {
                    Block block3 = world.getBlockAt(baseX + x3, baseY + y, baseZ + z2);
                    if (block3.getType() != Material.COBBLESTONE && block3.getType() != Material.STONE_BRICKS && block3.getType() != Material.ANDESITE || !(this.rand.nextDouble() < 0.1)) continue;
                    for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                        Block relative = block3.getRelative(face);
                        if (relative.getType() != Material.AIR) continue;
                        relative.setType(Material.VINE, false);
                        continue block11;
                    }
                }
            }
        }
        if (this.rand.nextDouble() < 0.2) {
            Block skullBlock = world.getBlockAt(baseX + 1 + this.rand.nextInt(2), baseY + 1, baseZ + 1 + this.rand.nextInt(2));
            skullBlock.setType(Material.SKELETON_SKULL, false);
        }
    }
}

