/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Campfire;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;

public class WagonCaravanWreck
extends RuinedStructures999.Structure {
    private final int footprintWidth = 12;
    private final int footprintLength = 8;
    private final Random rand = new Random();

    public WagonCaravanWreck(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(5);
            int highestY = world.getHighestBlockYAt(baseX + 6, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(9)) + 4);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, 12, 8) || !this.isAreaClear(world, baseX, highestY, baseZ, 12, 8, 5)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x = 0; x < 12; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 8; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    block.setType(Material.AIR, false);
                }
            }
        }
        int wagonCount = 2 + this.rand.nextInt(2);
        for (int i = 0; i < wagonCount; ++i) {
            int wx = baseX + 1 + this.rand.nextInt(8);
            int wz = baseZ + 1 + this.rand.nextInt(4);
            this.buildWagonFrame(world, wx, baseY, wz);
        }
        int fenceCount = 8 + this.rand.nextInt(5);
        for (int i = 0; i < fenceCount; ++i) {
            int fx = baseX + this.rand.nextInt(12);
            int fz = baseZ + this.rand.nextInt(8);
            Block block = world.getBlockAt(fx, baseY, fz);
            if (this.rand.nextBoolean()) {
                block.setType(Material.OAK_FENCE, false);
            } else {
                block.setType(Material.OAK_FENCE_GATE, false);
            }
            if (!(this.rand.nextDouble() < 0.3)) continue;
            block.setType(Material.AIR, false);
        }
        this.buildFirepit(world, baseX + 6, baseY, baseZ + 4);
        if (this.rand.nextDouble() < 0.5) {
            Location armorStandLoc = new Location(world, (double)(baseX + 6), (double)(baseY + 1), (double)(baseZ + 4 + 1));
            ArmorStand armorStand = (ArmorStand)world.spawn(armorStandLoc, ArmorStand.class);
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            armorStand.setHelmet(new ItemStack(Material.LEATHER_HELMET));
            armorStand.setCustomName("Remains");
            armorStand.setCustomNameVisible(false);
        }
        int barrelCount = 2 + this.rand.nextInt(2);
        for (int i = 0; i < barrelCount; ++i) {
            int bx = baseX + 1 + this.rand.nextInt(10);
            int bz = baseZ + 1 + this.rand.nextInt(6);
            Block barrelBlock = world.getBlockAt(bx, baseY + 1, bz);
            barrelBlock.setType(Material.BARREL, false);
            if (!(barrelBlock.getState() instanceof Barrel)) continue;
            Barrel barrel = (Barrel)barrelBlock.getState();
            barrel.getInventory().clear();
            this.fillBarrelLoot(barrel);
            barrel.update();
        }
    }

    private void buildWagonFrame(World world, int x, int y, int z) {
        for (int dx = 0; dx < 2; ++dx) {
            for (int dz = 0; dz < 3; ++dz) {
                Block block = world.getBlockAt(x + dx, y, z + dz);
                block.setType(Material.HAY_BLOCK, false);
            }
        }
        Block wheel1 = world.getBlockAt(x - 1, y, z + 1);
        wheel1.setType(Material.OAK_TRAPDOOR, false);
        TrapDoor trap1 = (TrapDoor)wheel1.getBlockData();
        trap1.setOpen(true);
        wheel1.setBlockData((BlockData)trap1, false);
        Block wheel2 = world.getBlockAt(x + 2, y, z + 1);
        wheel2.setType(Material.OAK_TRAPDOOR, false);
        TrapDoor trap2 = (TrapDoor)wheel2.getBlockData();
        trap2.setOpen(true);
        wheel2.setBlockData((BlockData)trap2, false);
        for (int dz = 0; dz < 3; ++dz) {
            Block plank = world.getBlockAt(x, y + 1, z + dz);
            plank.setType(Material.OAK_PLANKS, false);
            Block fence = world.getBlockAt(x + 1, y + 1, z + dz);
            fence.setType(Material.OAK_FENCE, false);
        }
    }

    private void buildFirepit(World world, int x, int y, int z) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Block block = world.getBlockAt(x + dx, y, z + dz);
                block.setType(Material.COBBLESTONE, false);
            }
        }
        Block campfireBlock = world.getBlockAt(x, y + 1, z);
        campfireBlock.setType(Material.CAMPFIRE, false);
        if (campfireBlock.getState() instanceof Campfire) {
            Campfire campfire = (Campfire)campfireBlock.getState();
            campfire.update();
        }
    }

    private void fillBarrelLoot(Barrel barrel) {
        int amount;
        Random rand = new Random();
        if (rand.nextInt(100) < 50) {
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.FILLED_MAP, 1)});
        }
        if (rand.nextInt(100) < 60) {
            amount = 2 + rand.nextInt(3);
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BREAD, amount)});
        }
        if (rand.nextInt(100) < 30) {
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS, 1)});
        }
        if (rand.nextInt(100) < 50) {
            amount = 2 + rand.nextInt(5);
            barrel.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BONE, amount)});
        }
    }
}

