/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Ladder;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;

public class WatchTower
extends RuinedStructures999.Structure {
    private final int width = 5;
    private final int length = 5;
    private final int height = 13;

    public WatchTower(String name, double spawnChance, Set<Biome> allowedBiomes, List<RuinedStructures999.LootEntry> lootEntries, Map<Enchantment, RuinedStructures999.IntRange> allowedEnchantments) {
        super(name, spawnChance, allowedBiomes, lootEntries, allowedEnchantments);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + new Random().nextInt(12);
            int highestY = world.getHighestBlockYAt(baseX + 2, (baseZ = chunk.getZ() * 16 + new Random().nextInt(12)) + 2);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            if (!this.isSolidGround(world, baseX, highestY - 1, baseZ, 5, 5) || !this.isAreaClear(world, baseX, highestY, baseZ, 5, 5, 13)) continue;
            return base;
        }
        return null;
    }

    private boolean isSolidGround(World world, int baseX, int baseY, int baseZ, int width, int length) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY, baseZ + z);
                if (block.getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAreaClear(World world, int baseX, int baseY, int baseZ, int width, int length, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    Block block = world.getBlockAt(baseX + x, baseY + y, baseZ + z);
                    Material type = block.getType();
                    if (type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void generate(Location base) {
        int chestX;
        int[][] corners;
        int z;
        int x;
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        Random rand = new Random();
        for (int x2 = 0; x2 < 5; ++x2) {
            for (int y = 0; y < 13; ++y) {
                for (int z2 = 0; z2 < 5; ++z2) {
                    Block block = world.getBlockAt(baseX + x2, baseY + y, baseZ + z2);
                    block.setType(Material.AIR, false);
                }
            }
        }
        for (int y = 0; y < 12; ++y) {
            for (int x3 = 0; x3 < 5; ++x3) {
                for (int z2 = 0; z2 < 5; ++z2) {
                    boolean isWall;
                    boolean bl = isWall = x3 == 0 || x3 == 4 || z2 == 0 || z2 == 4;
                    if (!isWall || rand.nextDouble() < 0.15) continue;
                    Block block = world.getBlockAt(baseX + x3, baseY + y, baseZ + z2);
                    Material material = Material.CRACKED_STONE_BRICKS;
                    block.setType(material, false);
                }
            }
        }
        int ladderX = baseX + 5 - 1;
        int[] ladderZs = new int[]{baseZ + 1, baseZ + 3};
        int ladderStartY = baseY;
        int ladderEndY = baseY + 13 - 2;
        ArrayList<Location> ladderPositions = new ArrayList<Location>();
        for (int zPos : ladderZs) {
            for (int y = ladderStartY; y <= ladderEndY; ++y) {
                ladderPositions.add(new Location(world, (double)ladderX, (double)y, (double)zPos));
            }
        }
        Collections.shuffle(ladderPositions, rand);
        HashSet hashSet = new HashSet(ladderPositions.subList(0, Math.min(2, ladderPositions.size())));
        for (int zPos : ladderZs) {
            for (int y = ladderStartY; y <= ladderEndY; ++y) {
                Location loc = new Location(world, (double)ladderX, (double)y, (double)zPos);
                if (hashSet.contains(loc)) continue;
                Block block = world.getBlockAt(ladderX, y, zPos);
                block.setType(Material.LADDER, false);
                Ladder ladderData = (Ladder)block.getBlockData();
                ladderData.setFacing(BlockFace.WEST);
                block.setBlockData((BlockData)ladderData, false);
                Block behindBlock = world.getBlockAt(ladderX - 1, y, zPos);
                behindBlock.setType(Material.CRACKED_STONE_BRICKS, false);
            }
        }
        int platformY = baseY + 13 - 2;
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                Block block = world.getBlockAt(baseX + x, platformY, baseZ + z);
                block.setType(Material.STONE_BRICKS, false);
            }
        }
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                int isEdgeZ;
                boolean isEdgeX = x == 0 || x == 4;
                int n = isEdgeZ = z == 0 || z == 4 ? 1 : 0;
                if (!isEdgeX && isEdgeZ == 0 || x == 4 && (z == 1 || z == 3)) continue;
                Block block = world.getBlockAt(baseX + x, platformY + 1, baseZ + z);
                block.setType(Material.OAK_FENCE, false);
            }
        }
        for (int[] corner : corners = new int[][]{{baseX, baseZ}, {baseX + 5 - 1, baseZ}, {baseX, baseZ + 5 - 1}, {baseX + 5 - 1, baseZ + 5 - 1}}) {
            int cx = corner[0];
            int cz = corner[1];
            for (int y = platformY + 1; y <= platformY + 4; ++y) {
                Block block = world.getBlockAt(cx, y, cz);
                block.setType(Material.OAK_FENCE, false);
            }
            Block slabBlock = world.getBlockAt(cx, platformY + 5, cz);
            slabBlock.setType(Material.OAK_SLAB, false);
        }
        int chainX = baseX + 2;
        int chainZ = baseZ + 2;
        Block chainBlock = world.getBlockAt(chainX, platformY + 5, chainZ);
        chainBlock.setType(Material.CHAIN, false);
        Block spawnerBlock = world.getBlockAt(chainX, platformY + 4, chainZ);
        spawnerBlock.setType(Material.SPAWNER, false);
        if (spawnerBlock.getState() instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)spawnerBlock.getState();
            spawner.setSpawnedType(EntityType.SKELETON);
            spawner.update();
        }
        if ((chestX = chainX + 1) >= baseX + 5) {
            chestX = chainX - 1;
        }
        Block chestBlock = world.getBlockAt(chestX, platformY + 4, chainZ);
        chestBlock.setType(Material.CHEST, false);
        if (chestBlock.getState() instanceof Chest) {
            Chest chest = (Chest)chestBlock.getState();
            this.fillChestLoot(chest);
            chest.update();
        }
    }
}

