/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class LootHandler
implements Listener {
    private final RuinedStructures999 plugin;
    private final Random random = new Random();

    public LootHandler(RuinedStructures999 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getInventory().getHolder() instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)event.getInventory().getHolder();
        Location loc = chest.getLocation();
        String structureType = this.plugin.getStructureTypeForChest(loc);
        if (structureType == null || this.plugin.isChestLooted(loc)) {
            return;
        }
        if (!chest.getInventory().isEmpty()) {
            return;
        }
        this.fillChest(chest.getInventory(), structureType);
        this.plugin.markChestAsLooted(loc);
        this.plugin.getLogger().info("Filled chest for structure '" + structureType + "' at " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ());
    }

    private void fillChest(Inventory inventory, String structureType) {
        inventory.clear();
        Map<ItemStack, Integer> lootPool = this.getLootPool(structureType);
        int itemsToPlace = 2 + this.random.nextInt(3);
        for (int i = 0; i < itemsToPlace; ++i) {
            ItemStack item;
            int slot = this.random.nextInt(inventory.getSize());
            for (int attempts = 0; inventory.getItem(slot) != null && attempts < 100; ++attempts) {
                slot = this.random.nextInt(inventory.getSize());
            }
            if (inventory.getItem(slot) != null || (item = this.getRandomItemFromPool(lootPool)) == null) continue;
            inventory.setItem(slot, item);
        }
    }

    private Map<ItemStack, Integer> getLootPool(String structureType) {
        HashMap<ItemStack, Integer> pool = new HashMap<ItemStack, Integer>();
        if ("piglin_village".equals(structureType)) {
            pool.put(new ItemStack(Material.GOLD_INGOT, 1 + this.random.nextInt(3)), 20);
            pool.put(new ItemStack(Material.GILDED_BLACKSTONE, 1 + this.random.nextInt(2)), 15);
            pool.put(new ItemStack(Material.PORKCHOP, 1 + this.random.nextInt(4)), 10);
            pool.put(new ItemStack(Material.LEATHER, 1 + this.random.nextInt(3)), 10);
            pool.put(new ItemStack(Material.NETHER_WART, 1 + this.random.nextInt(2)), 5);
        } else if ("collapsed_watchtower".equals(structureType)) {
            pool.put(new ItemStack(Material.ARROW, 5 + this.random.nextInt(11)), 20);
            pool.put(new ItemStack(Material.BOW), 10);
            pool.put(new ItemStack(Material.IRON_INGOT, 1 + this.random.nextInt(3)), 15);
            pool.put(new ItemStack(Material.COBBLESTONE, 5 + this.random.nextInt(16)), 10);
            pool.put(new ItemStack(Material.ROTTEN_FLESH, 1 + this.random.nextInt(5)), 5);
        }
        return pool;
    }

    private ItemStack getRandomItemFromPool(Map<ItemStack, Integer> pool) {
        int totalWeight = 0;
        for (int weight : pool.values()) {
            totalWeight += weight;
        }
        int randomValue = this.random.nextInt(totalWeight);
        int currentWeight = 0;
        for (Map.Entry<ItemStack, Integer> entry : pool.entrySet()) {
            if (randomValue >= (currentWeight += entry.getValue().intValue())) continue;
            return entry.getKey().clone();
        }
        return null;
    }
}

