/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Piglin;

public class PiglinVillage
extends RuinedStructures999.Structure {
    private static final int MIN_HOUSES = 3;
    private static final int MAX_HOUSES = 10;
    private static final int HOUSE_SIZE = 5;
    private static final int HOUSE_HEIGHT = 4;
    private static final int BIG_HOUSE_SIZE = 10;
    private static final int BIG_HOUSE_HEIGHT = 6;
    private static final int MIN_DISTANCE_BETWEEN_HOUSES = 8;
    private final Random rand = new Random();

    public PiglinVillage(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    private void buildGenericHouse(World world, Location base, int size, int height, boolean hasChest) {
        int z;
        int z2;
        int x;
        int x0 = base.getBlockX();
        int y0 = base.getBlockY();
        int z0 = base.getBlockZ();
        for (x = 0; x < size; ++x) {
            for (int y = -1; y <= height; ++y) {
                for (z2 = 0; z2 < size; ++z2) {
                    world.getBlockAt(x0 + x, y0 + y, z0 + z2).setType(Material.AIR, false);
                }
            }
        }
        for (x = 0; x < size; ++x) {
            for (z = 0; z < size; ++z) {
                world.getBlockAt(x0 + x, y0 - 1, z0 + z).setType(this.rand.nextDouble() < 0.7 ? Material.BLACKSTONE : Material.SOUL_SAND, false);
            }
        }
        for (int y = 0; y < height; ++y) {
            for (int x2 = 0; x2 < size; ++x2) {
                for (z2 = 0; z2 < size; ++z2) {
                    if (x2 != 0 && x2 != size - 1 && z2 != 0 && z2 != size - 1) continue;
                    double r = this.rand.nextDouble();
                    Material mat = r < 0.5 ? Material.NETHER_BRICKS : (r < 0.8 ? Material.BLACKSTONE : Material.CRACKED_NETHER_BRICKS);
                    world.getBlockAt(x0 + x2, y0 + y, z0 + z2).setType(mat, false);
                }
            }
        }
        for (x = -1; x <= size; ++x) {
            for (z = -1; z <= size; ++z) {
                world.getBlockAt(x0 + x, y0 + height, z0 + z).setType(Material.NETHER_BRICKS, false);
            }
        }
        ((Piglin)world.spawnEntity(new Location(world, (double)(x0 + size / 2), (double)y0, (double)(z0 + size / 2)), EntityType.PIGLIN)).setImmuneToZombification(true);
        if (size > 5) {
            ((Piglin)world.spawnEntity(new Location(world, (double)(x0 + size / 3), (double)y0, (double)(z0 + size / 3)), EntityType.PIGLIN)).setImmuneToZombification(true);
            ((Piglin)world.spawnEntity(new Location(world, (double)(x0 + 2 * size / 3), (double)y0, (double)(z0 + 2 * size / 3)), EntityType.PIGLIN)).setImmuneToZombification(true);
        }
        if (hasChest) {
            world.spawnEntity(new Location(world, (double)(x0 + size / 2), (double)y0, (double)(z0 + size / 2)), EntityType.PIGLIN_BRUTE);
            Block chestBlock = world.getBlockAt(x0 + 1, y0, z0 + 1);
            chestBlock.setType(Material.CHEST, false);
            if (chestBlock.getState() instanceof Chest) {
                RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
            }
        }
    }

    private void buildHouse(World world, Location base) {
        this.buildGenericHouse(world, base, 5, 4, false);
    }

    private void buildBigHouse(World world, Location base) {
        this.buildGenericHouse(world, base, 10, 6, true);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NETHER) {
            return null;
        }
        for (int y = 120; y > 10; --y) {
            int x = chunk.getX() * 16 + 8;
            int z = chunk.getZ() * 16 + 8;
            Block block = world.getBlockAt(x, y, z);
            Block blockAbove = world.getBlockAt(x, y + 1, z);
            Block blockBelow = world.getBlockAt(x, y - 1, z);
            if (block.getType() != Material.AIR || blockAbove.getType() != Material.AIR || blockBelow.isPassable()) continue;
            int airCount = 0;
            for (int dx = -5; dx <= 5; ++dx) {
                for (int dz = -5; dz <= 5; ++dz) {
                    if (world.getBlockAt(x + dx, y, z + dz).getType() != Material.AIR) continue;
                    ++airCount;
                }
            }
            if (airCount <= 25) continue;
            Biome biome = world.getBlockAt(x, y, z).getBiome();
            if (!this.getAllowedBiomes().isEmpty() && !this.getAllowedBiomes().contains(biome)) continue;
            int touchingAir = 0;
            if (world.getBlockAt(x + 1, y, z).isPassable()) {
                ++touchingAir;
            }
            if (world.getBlockAt(x - 1, y, z).isPassable()) {
                ++touchingAir;
            }
            if (world.getBlockAt(x, y, z + 1).isPassable()) {
                ++touchingAir;
            }
            if (world.getBlockAt(x, y, z - 1).isPassable()) {
                ++touchingAir;
            }
            if (world.getBlockAt(x, y + 1, z).isPassable()) {
                ++touchingAir;
            }
            if (world.getBlockAt(x, y - 1, z).isPassable()) {
                ++touchingAir;
            }
            if (touchingAir < 5) continue;
            return new Location(world, (double)(chunk.getX() * 16), (double)y, (double)(chunk.getZ() * 16));
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int startX = base.getBlockX();
        int startY = base.getBlockY();
        int startZ = base.getBlockZ();
        int houseCount = 3 + this.rand.nextInt(8);
        ArrayList<HouseInfo> houseInfos = new ArrayList<HouseInfo>();
        boolean firstBig = this.rand.nextDouble() < 0.25;
        int firstSize = firstBig ? 10 : 5;
        Location firstLoc = new Location(world, (double)startX, (double)startY, (double)startZ);
        houseInfos.add(new HouseInfo(firstLoc, firstSize, firstBig));
        this.buildGenericHouse(world, firstLoc, firstSize, firstBig ? 6 : 4, firstBig);
        int attempts = 0;
        while (houseInfos.size() < houseCount && attempts < 200) {
            ++attempts;
            HouseInfo lastHouse = (HouseInfo)houseInfos.get(houseInfos.size() - 1);
            int xOffset = this.rand.nextInt(16) - 8;
            int zOffset = this.rand.nextInt(16) - 8;
            int newX = lastHouse.location.getBlockX() + xOffset;
            int newZ = lastHouse.location.getBlockZ() + zOffset;
            int newY = startY;
            boolean big = this.rand.nextDouble() < 0.25;
            int size = big ? 10 : 5;
            Location newLoc = new Location(world, (double)newX, (double)newY, (double)newZ);
            boolean tooClose = false;
            for (HouseInfo existingHouse : houseInfos) {
                if (!(newLoc.distanceSquared(existingHouse.location) < 64.0)) continue;
                tooClose = true;
                break;
            }
            if (tooClose) continue;
            houseInfos.add(new HouseInfo(newLoc, size, big));
            this.buildGenericHouse(world, newLoc, size, big ? 6 : 4, big);
        }
        if (houseInfos.size() > 1) {
            for (int i = 0; i < houseInfos.size(); ++i) {
                HouseInfo currentHouse = (HouseInfo)houseInfos.get(i);
                HouseInfo nearestNeighbor = null;
                double minDistance = Double.MAX_VALUE;
                for (int j = 0; j < houseInfos.size(); ++j) {
                    if (i == j) continue;
                    HouseInfo neighbor = (HouseInfo)houseInfos.get(j);
                    double distance = currentHouse.location.distanceSquared(neighbor.location);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    nearestNeighbor = neighbor;
                }
                if (nearestNeighbor == null) continue;
                this.connectHousesWithPath(world, currentHouse, nearestNeighbor);
            }
        }
    }

    private void connectHousesWithPath(World world, HouseInfo house1, HouseInfo house2) {
        Block pathBlock;
        Location start = house1.entrance;
        Location end = house2.entrance;
        int x1 = start.getBlockX();
        int z1 = start.getBlockZ();
        int x2 = end.getBlockX();
        int z2 = end.getBlockZ();
        int y = start.getBlockY() - 1;
        for (int x = Math.min(x1, x2); x <= Math.max(x1, x2); ++x) {
            for (int dz = -1; dz <= 1; ++dz) {
                pathBlock = world.getBlockAt(x, y, z1 + dz);
                if (pathBlock.getType() != Material.AIR && !pathBlock.isLiquid()) continue;
                pathBlock.setType(Material.POLISHED_BLACKSTONE_BRICKS, false);
                world.getBlockAt(x, y + 1, z1 + dz).setType(Material.AIR, false);
                world.getBlockAt(x, y + 2, z1 + dz).setType(Material.AIR, false);
            }
        }
        for (int z = Math.min(z1, z2); z <= Math.max(z1, z2); ++z) {
            for (int dx = -1; dx <= 1; ++dx) {
                pathBlock = world.getBlockAt(x2 + dx, y, z);
                if (pathBlock.getType() != Material.AIR && !pathBlock.isLiquid()) continue;
                pathBlock.setType(Material.POLISHED_BLACKSTONE_BRICKS, false);
                world.getBlockAt(x2 + dx, y + 1, z).setType(Material.AIR, false);
                world.getBlockAt(x2 + dx, y + 2, z).setType(Material.AIR, false);
            }
        }
    }

    private static class HouseInfo {
        Location location;
        int size;
        boolean isBig;
        Location entrance;

        public HouseInfo(Location location, int size, boolean isBig) {
            this.location = location;
            this.size = size;
            this.isBig = isBig;
            this.entrance = new Location(location.getWorld(), (double)(location.getBlockX() + size / 2), (double)location.getBlockY(), (double)location.getBlockZ());
        }
    }
}

