/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Ladder;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WatchTower
extends RuinedStructures999.Structure {
    private final int width = 5;
    private final int length = 5;
    private final int height = 13;
    private final Random rand = new Random();

    public WatchTower(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(12);
            int highestY = world.getHighestBlockYAt(baseX + 2, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(12)) + 2);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            Biome biome = world.getBlockAt(baseX + 2, highestY, baseZ + 2).getBiome();
            if (!this.getAllowedBiomes().isEmpty() && !this.getAllowedBiomes().contains(biome)) continue;
            return base;
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        int[][] corners;
        int z;
        int x;
        int z2;
        final World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x2 = 0; x2 < 5; ++x2) {
            for (int y = 0; y < 13; ++y) {
                for (z2 = 0; z2 < 5; ++z2) {
                    world.getBlockAt(baseX + x2, baseY + y, baseZ + z2).setType(Material.AIR, false);
                }
            }
        }
        for (int y = 0; y < 12; ++y) {
            for (int x3 = 0; x3 < 5; ++x3) {
                for (z2 = 0; z2 < 5; ++z2) {
                    boolean isWall;
                    boolean bl = isWall = x3 == 0 || x3 == 4 || z2 == 0 || z2 == 4;
                    if (!isWall || this.rand.nextDouble() < 0.15) continue;
                    world.getBlockAt(baseX + x3, baseY + y, baseZ + z2).setType(Material.CRACKED_STONE_BRICKS, false);
                }
            }
        }
        int ladderX = baseX + 5 - 1;
        int[] ladderZs = new int[]{baseZ + 1, baseZ + 3};
        int ladderStartY = baseY;
        int ladderEndY = baseY + 13 - 2;
        ArrayList<Location> ladderPositions = new ArrayList<Location>();
        for (int zPos : ladderZs) {
            for (int y = ladderStartY; y <= ladderEndY; ++y) {
                ladderPositions.add(new Location(world, (double)ladderX, (double)y, (double)zPos));
            }
        }
        Collections.shuffle(ladderPositions, this.rand);
        HashSet missing = new HashSet(ladderPositions.subList(0, Math.min(2, ladderPositions.size())));
        for (int zPos : ladderZs) {
            for (int y = ladderStartY; y <= ladderEndY; ++y) {
                Location loc = new Location(world, (double)ladderX, (double)y, (double)zPos);
                Block behind = world.getBlockAt(ladderX - 1, y, zPos);
                behind.setType(Material.CRACKED_STONE_BRICKS, false);
                if (missing.contains(loc)) continue;
                Block block = world.getBlockAt(ladderX, y, zPos);
                block.setType(Material.LADDER, false);
                Ladder ladderData = (Ladder)block.getBlockData();
                ladderData.setFacing(BlockFace.WEST);
                block.setBlockData((BlockData)ladderData, false);
            }
        }
        int platformY = baseY + 13 - 2;
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                world.getBlockAt(baseX + x, platformY, baseZ + z).setType(Material.STONE_BRICKS, false);
            }
        }
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                int edgeZ;
                int edgeX = x == 0 || x == 4 ? 1 : 0;
                int n = edgeZ = z == 0 || z == 4 ? 1 : 0;
                if (edgeX == 0 && edgeZ == 0 || x == 4 && (z == 1 || z == 3)) continue;
                world.getBlockAt(baseX + x, platformY + 1, baseZ + z).setType(Material.OAK_FENCE, false);
            }
        }
        for (int[] c : corners = new int[][]{{baseX, baseZ}, {baseX + 5 - 1, baseZ}, {baseX, baseZ + 5 - 1}, {baseX + 5 - 1, baseZ + 5 - 1}}) {
            int cx = c[0];
            int cz = c[1];
            for (int y = platformY + 1; y <= platformY + 4; ++y) {
                world.getBlockAt(cx, y, cz).setType(Material.OAK_FENCE, false);
            }
            world.getBlockAt(cx, platformY + 5, cz).setType(Material.OAK_SLAB, false);
        }
        int chainX = baseX + 2;
        int chainZ = baseZ + 2;
        world.getBlockAt(chainX, platformY + 5, chainZ).setType(Material.CHAIN, false);
        Block spawnerBlock = world.getBlockAt(chainX, platformY + 4, chainZ);
        spawnerBlock.setType(Material.SPAWNER, false);
        BlockState cx = spawnerBlock.getState();
        if (cx instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)cx;
            spawner.setSpawnedType(EntityType.SKELETON);
            spawner.update();
        }
        final int chestX = chainX + 1 >= baseX + 5 ? chainX - 1 : chainX + 1;
        final int chestY = platformY + 2;
        final int chestZ = chainZ;
        new BukkitRunnable(){

            public void run() {
                Block chestBlock = world.getBlockAt(chestX, chestY, chestZ);
                chestBlock.setType(Material.CHEST, false);
                if (chestBlock.getState() instanceof Chest) {
                    RuinedStructures999.plugin.addChest(chestBlock.getLocation(), WatchTower.this.getName());
                }
            }
        }.runTask((Plugin)RuinedStructures999.plugin);
    }
}

