/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thebrokenscriptadditions.procedures;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.mcreator.thebrokenscriptadditions.entity.SpectatorEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpectatorOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        LivingEntity liv;
        if (entity == null) {
            return;
        }
        Vec3 _center = new Vec3(x, y, z);
        List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(256.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (entityiterator instanceof Player) {
                Vec3 lookVec;
                Vec3 reachPoint;
                Vec3 eyePos;
                LivingEntity liv2;
                Player player = (Player)entityiterator;
                entity.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
                if (entity instanceof LivingEntity && (liv2 = (LivingEntity)entity).hasEffect(MobEffects.INVISIBILITY)) continue;
                double margin = 2.0;
                AABB expandedBox = entity.getBoundingBox().inflate(margin);
                Optional hitOpt = expandedBox.clip(eyePos = player.getEyePosition(1.0f), reachPoint = eyePos.add((lookVec = player.getViewVector(1.0f)).scale(1.0E12)));
                if (hitOpt.isPresent()) {
                    if (!entity.level().isClientSide()) {
                        entity.discard();
                    }
                    if (world instanceof Level) {
                        Level _level = (Level)world;
                        if (!_level.isClientSide()) {
                            _level.playSound(null, BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"thebrokenscript_additions:spectator_disappear")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                        } else {
                            _level.playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"thebrokenscript_additions:spectator_disappear")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                        }
                    }
                }
            }
            if (!(entityiterator instanceof SpectatorEntity) || entityiterator == entity || entity.level().isClientSide()) continue;
            entity.discard();
        }
        if (entity instanceof LivingEntity && (liv = (LivingEntity)entity).getHealth() < liv.getMaxHealth() && !entity.level().isClientSide()) {
            entity.discard();
        }
        for (Entity playerEntity : world.players()) {
            double xDist = Math.abs(entity.getX() - playerEntity.getX());
            double yDist = Math.abs(entity.getY() - playerEntity.getY());
            double zDist = Math.abs(entity.getZ() - playerEntity.getZ());
            if (!(xDist > 10.0) && !(yDist > 10.0) && !(zDist > 10.0)) continue;
            entity.setDeltaMovement(Vec3.ZERO);
        }
    }
}

