/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig.Listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.levi.stolz.tablistConfig.util.PlaceholderReplacer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerJoinListener
implements Listener {
    private final JavaPlugin plugin;
    private final PlaceholderReplacer replacer;

    public PlayerJoinListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.replacer = new PlaceholderReplacer(plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        FileConfiguration config = this.plugin.getConfig();
        Component header = this.loadSection(config, "header", player);
        Component footer = this.loadSection(config, "footer", player);
        player.sendPlayerListHeaderAndFooter(header, footer);
    }

    private Component loadSection(FileConfiguration config, String sectionPrefix, Player player) {
        String key;
        TextComponent.Builder builder = Component.text();
        int index = 1;
        while (config.contains(key = sectionPrefix + "_" + index)) {
            String text = config.getString(key);
            if (text != null) {
                String replaced = this.replacer.replace(text, player);
                TextComponent lineComponent = LegacyComponentSerializer.legacySection().deserialize(replaced);
                builder.append((Component)lineComponent);
                builder.append((Component)Component.newline());
            }
            ++index;
        }
        return builder.build();
    }
}

