/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig.Listeners;

import net.levi.stolz.tablistConfig.PlayerDataManager;
import net.levi.stolz.tablistConfig.TablistGUI;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class GUIListener
implements Listener {
    private final JavaPlugin plugin;
    private final PlayerDataManager dataManager;
    private final TablistGUI gui;

    public GUIListener(JavaPlugin plugin, PlayerDataManager dataManager, TablistGUI gui) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.gui = gui;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals("Settings")) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        if (event.getSlot() != 13) {
            return;
        }
        boolean currentlyEnabled = this.dataManager.isTablistEnabled(player);
        this.dataManager.setTablistEnabled(player, !currentlyEnabled);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        this.gui.openGUI(player);
    }
}

