/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerDataManager {
    private final JavaPlugin plugin;
    private final File dataFile;
    private FileConfiguration dataConfig;

    public PlayerDataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "playerdata.yml");
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public boolean isTablistEnabled(Player player) {
        return this.dataConfig.getBoolean("players." + player.getUniqueId().toString() + ".tablistEnabled", true);
    }

    public void setTablistEnabled(Player player, boolean enabled) {
        this.dataConfig.set("players." + player.getUniqueId().toString() + ".tablistEnabled", (Object)enabled);
        this.saveData();
    }

    private void saveData() {
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save player data: " + e.getMessage());
        }
    }
}

