/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig;

import net.levi.stolz.tablistConfig.PlayerDataManager;
import net.levi.stolz.tablistConfig.TablistGUI;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TablistCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final PlayerDataManager dataManager;
    private final TablistGUI gui;

    public TablistCommand(JavaPlugin plugin, PlayerDataManager dataManager, TablistGUI gui) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.gui = gui;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /tablist reload | /tablist configure");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("tablist.admin")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            this.plugin.reloadConfig();
            sender.sendMessage("\u00a7aTablist configuration reloaded successfully!");
            return true;
        }
        if (args[0].equalsIgnoreCase("config")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cThis command can only be used by players.");
                return true;
            }
            if (!sender.hasPermission("tablist.configure")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            if (!this.plugin.getConfig().getBoolean("allow_toggle", true)) {
                sender.sendMessage("\u00a7cTablist toggling is disabled by the server administrator.");
                return true;
            }
            Player player = (Player)sender;
            this.gui.openGUI(player);
            return true;
        }
        sender.sendMessage("\u00a7cUnknown subcommand. Usage: /tablist reload | /tablist configure");
        return true;
    }
}

