/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig;

import java.util.Objects;
import net.levi.stolz.tablistConfig.Listeners.GUIListener;
import net.levi.stolz.tablistConfig.Listeners.PlayerJoinListener;
import net.levi.stolz.tablistConfig.PlayerDataManager;
import net.levi.stolz.tablistConfig.TablistCommand;
import net.levi.stolz.tablistConfig.TablistGUI;
import net.levi.stolz.tablistConfig.TablistUpdater;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TablistConfig
extends JavaPlugin {
    private TablistUpdater updater;
    private PlayerDataManager dataManager;
    private TablistGUI gui;

    public void onEnable() {
        this.getLogger().info("Started tablist plugin.");
        this.saveDefaultConfig();
        this.dataManager = new PlayerDataManager(this);
        this.gui = new TablistGUI(this, this.dataManager);
        this.updater = new TablistUpdater(this, this.dataManager);
        this.updater.start();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this, this.dataManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this, this.dataManager, this.gui), (Plugin)this);
        Objects.requireNonNull(this.getCommand("tablist")).setExecutor((CommandExecutor)new TablistCommand(this, this.dataManager, this.gui));
    }

    public void onDisable() {
        if (this.updater != null) {
            this.updater.stop();
        }
    }
}

