/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.levi.stolz.tablistConfig.PlayerDataManager;
import net.levi.stolz.tablistConfig.util.PlaceholderReplacer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class TablistUpdater {
    private final JavaPlugin plugin;
    private final PlaceholderReplacer replacer;
    private final PlayerDataManager dataManager;
    private BukkitTask task;

    public TablistUpdater(JavaPlugin plugin, PlayerDataManager dataManager) {
        this.plugin = plugin;
        this.replacer = new PlaceholderReplacer(plugin);
        this.dataManager = dataManager;
    }

    public void start() {
        if (this.task != null && !this.task.isCancelled()) {
            return;
        }
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            FileConfiguration config = this.plugin.getConfig();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.dataManager.isTablistEnabled(player)) {
                    Component header = this.buildSection(config, "header", player);
                    Component footer = this.buildSection(config, "footer", player);
                    player.sendPlayerListHeaderAndFooter(header, footer);
                    continue;
                }
                player.sendPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty());
            }
        }, 0L, 20L);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private Component buildSection(FileConfiguration config, String sectionPrefix, Player player) {
        String key;
        TextComponent.Builder builder = Component.text();
        int index = 1;
        while (config.contains(key = sectionPrefix + "_" + index)) {
            String text = config.getString(key);
            if (text != null) {
                String replaced = this.replacer.replace(text, player);
                Component line = MiniMessage.miniMessage().deserialize((Object)replaced);
                builder.append(line);
                String nextKey = sectionPrefix + "_" + (index + 1);
                if (config.contains(nextKey)) {
                    builder.append((Component)Component.newline());
                }
            }
            ++index;
        }
        return builder.build();
    }
}

