/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.tablistConfig.util;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderReplacer {
    private final JavaPlugin plugin;
    private final DecimalFormat format = new DecimalFormat("#0.##");

    public PlaceholderReplacer(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public String replace(String text, Player player) {
        String msptStr;
        String tpsStr;
        block7: {
            if (text == null) {
                return "";
            }
            int online = Bukkit.getOnlinePlayers().size();
            text = text.replace("%online%", String.valueOf(online));
            text = text.replace("%players_online%", String.valueOf(online));
            String ping = this.getPing(player);
            text = text.replace("%ping%", ping);
            String playerName = player != null ? player.getName() : "Unknown";
            text = text.replace("%player%", playerName);
            double tps = this.fetchTpsValue();
            tpsStr = "N/A";
            msptStr = "N/A";
            if (!Double.isNaN(tps)) {
                tpsStr = new DecimalFormat("#0.0").format(tps);
            }
            try {
                double avg = Bukkit.getServer().getAverageTickTime();
                if (!Double.isNaN(avg) && avg > 0.0) {
                    msptStr = this.format.format(avg);
                } else if (!Double.isNaN(tps) && tps > 0.0) {
                    double mspt = 1000.0 / tps;
                    msptStr = this.format.format(mspt);
                }
            }
            catch (Throwable ignored) {
                if (Double.isNaN(tps) || !(tps > 0.0)) break block7;
                double mspt = 1000.0 / tps;
                msptStr = this.format.format(mspt);
            }
        }
        text = text.replace("%tps%", tpsStr);
        text = text.replace("%mspt%", msptStr);
        return text;
    }

    private String getPing(Player player) {
        if (player == null) {
            return "N/A";
        }
        try {
            Method getPing = player.getClass().getMethod("getPing", new Class[0]);
            Object raw = getPing.invoke((Object)player, new Object[0]);
            if (raw instanceof Number) {
                return String.valueOf(((Number)raw).intValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "N/A";
    }

    private double fetchTpsValue() {
        try {
            double[] tps = Bukkit.getServer().getTPS();
            if (tps != null && tps.length > 0) {
                return tps[0];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Double.NaN;
    }
}

