/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.bettercoords;

import java.util.HashMap;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BetterCoords
extends JavaPlugin
implements Listener {
    private HashMap<UUID, Boolean> playerToggles = new HashMap();
    private String coordFormat;
    private int updateFrequency;
    private boolean enabledByDefault;
    private String actionBarPrefix;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("coords").setExecutor(new CoordsCommand());
        this.startActionBarUpdater();
        this.getLogger().info("BetterCoords has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("BetterCoords has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.coordFormat = ChatColor.translateAlternateColorCodes('&', config.getString("format", "&7X: &a%x% &7Y: &a%y% &7Z: &a%z%"));
        this.updateFrequency = config.getInt("update-frequency", 10);
        this.enabledByDefault = config.getBoolean("enabled-by-default", true);
        this.actionBarPrefix = ChatColor.translateAlternateColorCodes('&', config.getString("prefix", "&8[&bBetterCoords&8] "));
    }

    private void startActionBarUpdater() {
        new BukkitRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    UUID playerUUID = player.getUniqueId();
                    if (!BetterCoords.this.playerToggles.getOrDefault(playerUUID, BetterCoords.this.enabledByDefault).booleanValue()) continue;
                    int x = player.getLocation().getBlockX();
                    int y = player.getLocation().getBlockY();
                    int z = player.getLocation().getBlockZ();
                    String coords = BetterCoords.this.coordFormat.replace("%x%", String.valueOf(x)).replace("%y%", String.valueOf(y)).replace("%z%", String.valueOf(z));
                    BetterCoords.this.sendActionBar(player, BetterCoords.this.actionBarPrefix + coords);
                }
            }
        }.runTaskTimer(this, 0L, Math.max(1, this.updateFrequency));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.playerToggles.containsKey(player.getUniqueId())) {
            this.playerToggles.put(player.getUniqueId(), this.enabledByDefault);
        }
    }

    private void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText(message));
    }

    private class CoordsCommand
    implements CommandExecutor {
        private CoordsCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            UUID playerUUID = player.getUniqueId();
            boolean currentState = BetterCoords.this.playerToggles.getOrDefault(playerUUID, BetterCoords.this.enabledByDefault);
            BetterCoords.this.playerToggles.put(playerUUID, !currentState);
            if (!currentState) {
                player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Coordinates display enabled.");
            } else {
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Coordinates display disabled.");
                BetterCoords.this.sendActionBar(player, "");
            }
            return true;
        }
    }
}

