/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.block;

import com.skniro.maple.block.entity.MapleBlockSetType;
import com.skniro.maple.block.entity.MapleWoodTypes;
import com.skniro.maple.block.init.MapleCarpetBlock;
import com.skniro.maple.block.init.MapleGlassSlabBlock;
import com.skniro.maple.block.init.MapleGlassStairsBlock;
import com.skniro.maple.block.init.MapleJuicerBlock;
import com.skniro.maple.block.init.MapleTeaBlock;
import com.skniro.maple.block.init.RiceBlock;
import com.skniro.maple.particle.MapleParticleTypes;
import com.skniro.maple.world.Tree.CherrySaplingGenerator;
import com.skniro.maple.world.Tree.GinkgoSaplingGenerator;
import com.skniro.maple.world.Tree.MapleSaplingGenerator;
import com.skniro.maple.world.Tree.RedMapleSaplingGenerator;
import com.skniro.maple.world.Tree.SakuraSaplingGenerator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MapleBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"maple");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"maple");
    public static final Supplier<Block> MAPLE_LOG = MapleBlocks.registerBlock("maple_log", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(MapColor.COLOR_BROWN));
    public static final Supplier<Block> STRIPPED_MAPLE_LOG = MapleBlocks.registerBlock("stripped_maple_log", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(MapColor.COLOR_BROWN));
    public static final Supplier<Block> STRIPPED_MAPLE_WOOD = MapleBlocks.registerBlock("stripped_maple_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(MapColor.COLOR_BROWN));
    public static final Supplier<Block> MAPLE_WOOD = MapleBlocks.registerBlock("maple_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(MapColor.COLOR_BROWN));
    public static final Supplier<Block> GINKGO_LOG = MapleBlocks.registerBlock("ginkgo_log", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(MapColor.SAND));
    public static final Supplier<Block> STRIPPED_GINKGO_LOG = MapleBlocks.registerBlock("stripped_ginkgo_log", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(MapColor.SAND));
    public static final Supplier<Block> STRIPPED_GINKGO_WOOD = MapleBlocks.registerBlock("stripped_ginkgo_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(MapColor.SAND));
    public static final Supplier<Block> GINKGO_WOOD = MapleBlocks.registerBlock("ginkgo_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(MapColor.SAND));
    public static final Supplier<Block> CHERRY_LOG = MapleBlocks.registerBlock("cherry_log", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG));
    public static final Supplier<Block> CHERRY_WOOD = MapleBlocks.registerBlock("cherry_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD));
    public static final Supplier<Block> STRIPPED_CHERRY_LOG = MapleBlocks.registerBlock("stripped_cherry_log", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG));
    public static final Supplier<Block> STRIPPED_CHERRY_WOOD = MapleBlocks.registerBlock("stripped_cherry_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD));
    public static final Supplier<Block> BAMBOO_BLOCK = MapleBlocks.registerBlock("bamboo_block", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(2.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> STRIPPED_BAMBOO_BLOCK = MapleBlocks.registerBlock("stripped_bamboo_block", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> MAPLE_SAPLING = MapleBlocks.registerBlock("maple_sapling", settings -> new SaplingBlock(MapleSaplingGenerator.MapleSapling, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> RED_MAPLE_SAPLING = MapleBlocks.registerBlock("red_maple_sapling", settings -> new SaplingBlock(RedMapleSaplingGenerator.RedMapleSapling, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> GINKGO_SAPLING = MapleBlocks.registerBlock("ginkgo_sapling", settings -> new SaplingBlock(GinkgoSaplingGenerator.GinkgoSapling, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> CHERRY_SAPLING = MapleBlocks.registerBlock("cherry_sapling", settings -> new SaplingBlock(CherrySaplingGenerator.CherrySapling, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> SAKURA_SAPLING = MapleBlocks.registerBlock("sakura_sapling", settings -> new SaplingBlock(SakuraSaplingGenerator.SakuraSapling, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> MAPLE_LEAVES = MapleBlocks.registerBlock("maple_leaves", settings -> new TintedParticleLeavesBlock(0.1f, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.TERRACOTTA_YELLOW));
    public static final Supplier<Block> RED_MAPLE_LEAVES = MapleBlocks.registerBlock("red_maple_leaves", settings -> new TintedParticleLeavesBlock(0.1f, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.COLOR_RED));
    public static final Supplier<Block> GINKGO_LEAVES = MapleBlocks.registerBlock("ginkgo_leaves", settings -> new TintedParticleLeavesBlock(0.1f, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.TERRACOTTA_YELLOW));
    public static final Supplier<Block> CHERRY_LEAVES = MapleBlocks.registerBlock("cherry_leaves", settings -> new UntintedParticleLeavesBlock(10.0f, (ParticleOptions)ParticleTypes.CHERRY_LEAVES, settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.COLOR_PINK));
    public static final Supplier<Block> SAKURA_LEAVES = MapleBlocks.registerBlock("sakura_leaves", settings -> new UntintedParticleLeavesBlock(0.1f, (ParticleOptions)MapleParticleTypes.SAKURA_LEAVES.get(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.COLOR_PINK).lightLevel(state -> 8));
    public static final Supplier<Block> MAPLE_PLANKS = MapleBlocks.registerBlock("maple_planks", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(MapColor.COLOR_BROWN));
    public static final Supplier<Block> CHERRY_PLANKS = MapleBlocks.registerBlock("cherry_planks", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(MapColor.COLOR_PINK));
    public static final Supplier<Block> GINKGO_PLANKS = MapleBlocks.registerBlock("ginkgo_planks", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(MapColor.TERRACOTTA_YELLOW));
    public static final Supplier<Block> BAMBOO_PLANKS = MapleBlocks.registerBlock("bamboo_planks", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> BAMBOO_MOSAIC = MapleBlocks.registerBlock("bamboo_mosaic", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> POTTED_GINKGO_SAPLING = MapleBlocks.registerBlockWithoutItem("potted_ginkgo_sapling", settings -> new FlowerPotBlock(GINKGO_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> POTTED_CHERRY_SAPLING = MapleBlocks.registerBlockWithoutItem("potted_cherry_sapling", settings -> new FlowerPotBlock(CHERRY_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> POTTED_MAPLE_SAPLING = MapleBlocks.registerBlockWithoutItem("potted_maple_sapling", settings -> new FlowerPotBlock(MAPLE_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> POTTED_RED_MAPLE_SAPLING = MapleBlocks.registerBlockWithoutItem("potted_red_maple_sapling", settings -> new FlowerPotBlock(RED_MAPLE_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> POTTED_SAKURA_SAPLING = MapleBlocks.registerBlockWithoutItem("potted_sakura_sapling", settings -> new FlowerPotBlock(SAKURA_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> GINKGO_BUTTON = MapleBlocks.registerBlock("ginkgo_button", settings -> new ButtonBlock(MapleBlockSetType.GINKGO, 30, settings), MapleBlocks.buttonProperties());
    public static final Supplier<Block> CHERRY_BUTTON = MapleBlocks.registerBlock("cherry_button", settings -> new ButtonBlock(BlockSetType.CHERRY, 30, settings), MapleBlocks.buttonProperties());
    public static final Supplier<Block> MAPLE_BUTTON = MapleBlocks.registerBlock("maple_button", settings -> new ButtonBlock(MapleBlockSetType.MAPLE, 30, settings), MapleBlocks.buttonProperties());
    public static final Supplier<Block> BAMBOO_BUTTON = MapleBlocks.registerBlock("bamboo_button", settings -> new ButtonBlock(BlockSetType.BAMBOO, 30, settings), MapleBlocks.buttonProperties());
    public static final Supplier<Block> GINKGO_STAIRS = MapleBlocks.registerBlock("ginkgo_stairs", settings -> new StairBlock(Blocks.CHERRY_PLANKS.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS));
    public static final Supplier<Block> CHERRY_STAIRS = MapleBlocks.registerBlock("cherry_stairs", settings -> new StairBlock(Blocks.CHERRY_PLANKS.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS));
    public static final Supplier<Block> MAPLE_STAIRS = MapleBlocks.registerBlock("maple_stairs", settings -> new StairBlock(Blocks.CHERRY_PLANKS.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS));
    public static final Supplier<Block> BAMBOO_STAIRS = MapleBlocks.registerBlock("bamboo_stairs", settings -> new StairBlock(Blocks.BAMBOO_PLANKS.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS));
    public static final Supplier<Block> BAMBOO_MOSAIC_STAIRS = MapleBlocks.registerBlock("bamboo_mosaic_stairs", settings -> new StairBlock(Blocks.BAMBOO_MOSAIC.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_MOSAIC));
    public static final Supplier<Block> GINKGO_SLAB = MapleBlocks.registerBlock("ginkgo_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> CHERRY_SLAB = MapleBlocks.registerBlock("cherry_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> MAPLE_SLAB = MapleBlocks.registerBlock("maple_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BROWN).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> BAMBOO_SLAB = MapleBlocks.registerBlock("bamboo_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> BAMBOO_MOSAIC_SLAB = MapleBlocks.registerBlock("bamboo_mosaic_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> GINKGO_FENCE_GATE = MapleBlocks.registerBlock("ginkgo_fence_gate", settings -> new FenceGateBlock(MapleWoodTypes.GINKGO, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f, 3.0f));
    public static final Supplier<Block> GINKGO_FENCE = MapleBlocks.registerBlock("ginkgo_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> CHERRY_FENCE_GATE = MapleBlocks.registerBlock("cherry_fence_gate", settings -> new FenceGateBlock(WoodType.CHERRY, settings), BlockBehaviour.Properties.of().mapColor(Blocks.CHERRY_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
    public static final Supplier<Block> CHERRY_FENCE = MapleBlocks.registerBlock("cherry_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(Blocks.CHERRY_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> MAPLE_FENCE_GATE = MapleBlocks.registerBlock("maple_fence_gate", settings -> new FenceGateBlock(MapleWoodTypes.MAPLE, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(2.0f, 3.0f));
    public static final Supplier<Block> MAPLE_FENCE = MapleBlocks.registerBlock("maple_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> BAMBOO_FENCE_GATE = MapleBlocks.registerBlock("bamboo_fence_gate", settings -> new FenceGateBlock(WoodType.BAMBOO, settings), BlockBehaviour.Properties.of().mapColor(Blocks.BAMBOO_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
    public static final Supplier<Block> BAMBOO_FENCE = MapleBlocks.registerBlock("bamboo_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(Blocks.BAMBOO_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final Supplier<Block> GINKGO_DOOR = MapleBlocks.registerBlockWithoutItem("ginkgo_door", settings -> new DoorBlock(MapleBlockSetType.GINKGO, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(3.0f).sound(SoundType.WOOD).noOcclusion());
    public static final Supplier<Block> MAPLE_DOOR = MapleBlocks.registerBlockWithoutItem("maple_door", settings -> new DoorBlock(BlockSetType.CHERRY, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(3.0f).sound(SoundType.WOOD).noOcclusion());
    public static final Supplier<Block> CHERRY_DOOR = MapleBlocks.registerBlockWithoutItem("cherry_door", settings -> new DoorBlock(MapleBlockSetType.MAPLE, settings), BlockBehaviour.Properties.of().mapColor(Blocks.CHERRY_PLANKS.defaultMapColor()).strength(3.0f).sound(SoundType.WOOD).noOcclusion());
    public static final Supplier<Block> BAMBOO_DOOR = MapleBlocks.registerBlockWithoutItem("bamboo_door", settings -> new DoorBlock(BlockSetType.BAMBOO, settings), BlockBehaviour.Properties.of().mapColor(Blocks.BAMBOO_PLANKS.defaultMapColor()).strength(3.0f).sound(SoundType.WOOD).noOcclusion());
    public static final Supplier<Block> GINKGO_TRAPDOOR = MapleBlocks.registerBlock("ginkgo_trapdoor", settings -> new TrapDoorBlock(MapleBlockSetType.GINKGO, settings), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).strength(3.0f).noOcclusion());
    public static final Supplier<Block> CHERRY_TRAPDOOR = MapleBlocks.registerBlock("cherry_trapdoor", settings -> new TrapDoorBlock(BlockSetType.CHERRY, settings), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).strength(3.0f).noOcclusion());
    public static final Supplier<Block> MAPLE_TRAPDOOR = MapleBlocks.registerBlock("maple_trapdoor", settings -> new TrapDoorBlock(MapleBlockSetType.MAPLE, settings), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BROWN).strength(3.0f).noOcclusion());
    public static final Supplier<Block> BAMBOO_TRAPDOOR = MapleBlocks.registerBlock("bamboo_trapdoor", settings -> new TrapDoorBlock(BlockSetType.BAMBOO, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(3.0f).noOcclusion());
    public static final Supplier<Block> GINKGO_PRESSURE_PLATE = MapleBlocks.registerBlock("ginkgo_pressure_plate", settings -> new PressurePlateBlock(MapleBlockSetType.GINKGO, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).noCollision().strength(0.5f).ignitedByLava().instrument(NoteBlockInstrument.BASS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> CHERRY_PRESSURE_PLATE = MapleBlocks.registerBlock("cherry_pressure_plate", settings -> new PressurePlateBlock(BlockSetType.CHERRY, settings), BlockBehaviour.Properties.of().mapColor(Blocks.CHERRY_PLANKS.defaultMapColor()).noCollision().strength(0.5f).ignitedByLava().instrument(NoteBlockInstrument.BASS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> MAPLE_PRESSURE_PLATE = MapleBlocks.registerBlock("maple_pressure_plate", settings -> new PressurePlateBlock(MapleBlockSetType.MAPLE, settings), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).noCollision().strength(0.5f).ignitedByLava().instrument(NoteBlockInstrument.BASS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> BAMBOO_PRESSURE_PLATE = MapleBlocks.registerBlock("bamboo_pressure_plate", settings -> new PressurePlateBlock(BlockSetType.BAMBOO, settings), BlockBehaviour.Properties.of().mapColor(Blocks.BAMBOO_PLANKS.defaultMapColor()).noCollision().strength(0.5f).ignitedByLava().instrument(NoteBlockInstrument.BASS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> RICE = MapleBlocks.registerBlockWithoutItem("rice_plant", RiceBlock::new, BlockBehaviour.Properties.of().noCollision().randomTicks().instabreak().sound(SoundType.CROP));
    public static final Supplier<Block> PINK_PETALS = MapleBlocks.registerBlock("pink_petals", FlowerBedBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollision().sound(SoundType.GRASS));
    public static final Supplier<Block> CHISELED_BOOKSHELF = MapleBlocks.registerBlock("chiseled_bookshelf", ChiseledBookShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(1.5f).sound(SoundType.WOOD));
    public static final Supplier<Block> SAKURA_CARPET = MapleBlocks.registerBlock("sakura_carpet", MapleCarpetBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).mapColor(MapColor.COLOR_PINK));
    public static final Supplier<Block> Maple_CARPET = MapleBlocks.registerBlock("maple_carpet", MapleCarpetBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).mapColor(MapColor.TERRACOTTA_YELLOW));
    public static final Supplier<Block> RED_MAPLE_CARPET = MapleBlocks.registerBlock("red_maple_carpet", MapleCarpetBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).mapColor(MapColor.COLOR_RED));
    public static final Supplier<Block> GINKGO_CARPET = MapleBlocks.registerBlock("ginkgo_carpet", MapleCarpetBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).mapColor(MapColor.TERRACOTTA_YELLOW));
    public static final Supplier<Block> WHITE_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("white_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS));
    public static final Supplier<Block> WHITE_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("white_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.WHITE_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS));
    public static final Supplier<Block> ORANGE_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("orange_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_STAINED_GLASS));
    public static final Supplier<Block> ORANGE_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("orange_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.ORANGE_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_STAINED_GLASS));
    public static final Supplier<Block> MAGENTA_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("magenta_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_STAINED_GLASS));
    public static final Supplier<Block> MAGENTA_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("magenta_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.MAGENTA_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_STAINED_GLASS));
    public static final Supplier<Block> LIGHT_BLUE_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("light_blue_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_BLUE_STAINED_GLASS));
    public static final Supplier<Block> LIGHT_BLUE_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("light_blue_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.LIGHT_BLUE_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_BLUE_STAINED_GLASS));
    public static final Supplier<Block> YELLOW_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("yellow_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_STAINED_GLASS));
    public static final Supplier<Block> YELLOW_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("yellow_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.YELLOW_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_STAINED_GLASS));
    public static final Supplier<Block> LIME_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("lime_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_STAINED_GLASS));
    public static final Supplier<Block> LIME_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("lime_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.LIME_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_STAINED_GLASS));
    public static final Supplier<Block> PINK_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("pink_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_STAINED_GLASS));
    public static final Supplier<Block> PINK_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("pink_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.PINK_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_STAINED_GLASS));
    public static final Supplier<Block> GRAY_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("gray_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_STAINED_GLASS));
    public static final Supplier<Block> GRAY_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("gray_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.GRAY_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_STAINED_GLASS));
    public static final Supplier<Block> LIGHT_GRAY_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("light_gray_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_STAINED_GLASS));
    public static final Supplier<Block> LIGHT_GRAY_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("light_gray_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.LIGHT_GRAY_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_STAINED_GLASS));
    public static final Supplier<Block> CYAN_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("cyan_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_STAINED_GLASS));
    public static final Supplier<Block> CYAN_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("cyan_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.CYAN_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_STAINED_GLASS));
    public static final Supplier<Block> PURPLE_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("purple_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_STAINED_GLASS));
    public static final Supplier<Block> PURPLE_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("purple_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.PURPLE_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_STAINED_GLASS));
    public static final Supplier<Block> BLUE_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("blue_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_STAINED_GLASS));
    public static final Supplier<Block> BLUE_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("blue_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.BLUE_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_STAINED_GLASS));
    public static final Supplier<Block> BROWN_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("brown_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_STAINED_GLASS));
    public static final Supplier<Block> BROWN_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("brown_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.BROWN_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_STAINED_GLASS));
    public static final Supplier<Block> GREEN_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("green_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_STAINED_GLASS));
    public static final Supplier<Block> GREEN_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("green_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.GREEN_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_STAINED_GLASS));
    public static final Supplier<Block> RED_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("red_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_STAINED_GLASS));
    public static final Supplier<Block> RED_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("red_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.RED_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_STAINED_GLASS));
    public static final Supplier<Block> BLACK_STAINED_GLASS_SLAB = MapleBlocks.registerBlock("black_stained_glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_STAINED_GLASS));
    public static final Supplier<Block> BLACK_STAINED_GLASS_STAIRS = MapleBlocks.registerBlock("black_stained_glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.BLACK_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_STAINED_GLASS));
    public static final Supplier<Block> GLASS_SLAB = MapleBlocks.registerBlock("glass_slab", MapleGlassSlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
    public static final Supplier<Block> GLASS_STAIRS = MapleBlocks.registerBlock("glass_stairs", settings -> new MapleGlassStairsBlock(Blocks.BLACK_STAINED_GLASS.defaultBlockState(), (BlockBehaviour.Properties)settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
    public static final Supplier<Block> TATAMI = MapleBlocks.registerBlock("tatami", HayBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK).mapColor(MapColor.COLOR_GREEN));
    public static final Supplier<Block> TATAMI_SLAB = MapleBlocks.registerBlock("tatami_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK).mapColor(MapColor.COLOR_GREEN));
    public static final Supplier<Block> GREEN_PLASTER = MapleBlocks.registerBlock("green_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CONCRETE));
    public static final Supplier<Block> PLASTER = MapleBlocks.registerBlock("plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE));
    public static final Supplier<Block> ORANGE_PLASTER = MapleBlocks.registerBlock("orange_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_CONCRETE));
    public static final Supplier<Block> MAGENTA_PLASTER = MapleBlocks.registerBlock("magenta_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE));
    public static final Supplier<Block> LIGHT_BLUE_PLASTER = MapleBlocks.registerBlock("light_blue_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_BLUE_CONCRETE));
    public static final Supplier<Block> YELLOW_PLASTER = MapleBlocks.registerBlock("yellow_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_CONCRETE));
    public static final Supplier<Block> LIME_PLASTER = MapleBlocks.registerBlock("lime_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_CONCRETE));
    public static final Supplier<Block> PINK_PLASTER = MapleBlocks.registerBlock("pink_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_CONCRETE));
    public static final Supplier<Block> GRAY_PLASTER = MapleBlocks.registerBlock("gray_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_CONCRETE));
    public static final Supplier<Block> LIGHT_GRAY_PLASTER = MapleBlocks.registerBlock("light_gray_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_CONCRETE));
    public static final Supplier<Block> CYAN_PLASTER = MapleBlocks.registerBlock("cyan_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_CONCRETE));
    public static final Supplier<Block> PURPLE_PLASTER = MapleBlocks.registerBlock("purple_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_CONCRETE));
    public static final Supplier<Block> BLUE_PLASTER = MapleBlocks.registerBlock("blue_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_CONCRETE));
    public static final Supplier<Block> BROWN_PLASTER = MapleBlocks.registerBlock("brown_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_CONCRETE));
    public static final Supplier<Block> RED_PLASTER = MapleBlocks.registerBlock("red_plaster", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_CONCRETE));
    public static final Supplier<Block> Iron_Sea_Lantern = MapleBlocks.registerBlock("iron_sea_lantern", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN));
    public static final Supplier<Block> Gold_Sea_Lantern = MapleBlocks.registerBlock("gold_sea_lantern", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN));
    public static final Supplier<Block> WHITE_CONCRETE_STAIRS = MapleBlocks.registerBlock("white_concrete_stairs", settings -> new StairBlock(Blocks.WHITE_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE));
    public static final Supplier<Block> WHITE_CONCRETE_SLAB = MapleBlocks.registerBlock("white_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE));
    public static final Supplier<Block> ORANGE_CONCRETE_STAIRS = MapleBlocks.registerBlock("orange_concrete_stairs", settings -> new StairBlock(Blocks.ORANGE_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_CONCRETE));
    public static final Supplier<Block> ORANGE_CONCRETE_SLAB = MapleBlocks.registerBlock("orange_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_CONCRETE));
    public static final Supplier<Block> MAGENTA_CONCRETE_STAIRS = MapleBlocks.registerBlock("magenta_concrete_stairs", settings -> new StairBlock(Blocks.MAGENTA_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE));
    public static final Supplier<Block> MAGENTA_CONCRETE_SLAB = MapleBlocks.registerBlock("magenta_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE));
    public static final Supplier<Block> LIGHT_BLUE_CONCRETE_STAIRS = MapleBlocks.registerBlock("light_blue_concrete_stairs", settings -> new StairBlock(Blocks.MAGENTA_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE));
    public static final Supplier<Block> LIGHT_BLUE_CONCRETE_SLAB = MapleBlocks.registerBlock("light_blue_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGENTA_CONCRETE));
    public static final Supplier<Block> YELLOW_CONCRETE_STAIRS = MapleBlocks.registerBlock("yellow_concrete_stairs", settings -> new StairBlock(Blocks.YELLOW_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_CONCRETE));
    public static final Supplier<Block> YELLOW_CONCRETE_SLAB = MapleBlocks.registerBlock("yellow_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_CONCRETE));
    public static final Supplier<Block> LIME_CONCRETE_STAIRS = MapleBlocks.registerBlock("lime_concrete_stairs", settings -> new StairBlock(Blocks.LIME_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_CONCRETE));
    public static final Supplier<Block> LIME_CONCRETE_SLAB = MapleBlocks.registerBlock("lime_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIME_CONCRETE));
    public static final Supplier<Block> PINK_CONCRETE_STAIRS = MapleBlocks.registerBlock("pink_concrete_stairs", settings -> new StairBlock(Blocks.PINK_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_CONCRETE));
    public static final Supplier<Block> PINK_CONCRETE_SLAB = MapleBlocks.registerBlock("pink_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_CONCRETE));
    public static final Supplier<Block> GRAY_CONCRETE_STAIRS = MapleBlocks.registerBlock("gray_concrete_stairs", settings -> new StairBlock(Blocks.GRAY_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_CONCRETE));
    public static final Supplier<Block> GRAY_CONCRETE_SLAB = MapleBlocks.registerBlock("gray_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_CONCRETE));
    public static final Supplier<Block> LIGHT_GRAY_CONCRETE_STAIRS = MapleBlocks.registerBlock("light_gray_concrete_stairs", settings -> new StairBlock(Blocks.LIGHT_GRAY_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_CONCRETE));
    public static final Supplier<Block> LIGHT_GRAY_CONCRETE_SLAB = MapleBlocks.registerBlock("light_gray_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_CONCRETE));
    public static final Supplier<Block> CYAN_CONCRETE_STAIRS = MapleBlocks.registerBlock("cyan_concrete_stairs", settings -> new StairBlock(Blocks.CYAN_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_CONCRETE));
    public static final Supplier<Block> CYAN_CONCRETE_SLAB = MapleBlocks.registerBlock("cyan_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_CONCRETE));
    public static final Supplier<Block> PURPLE_CONCRETE_STAIRS = MapleBlocks.registerBlock("purple_concrete_stairs", settings -> new StairBlock(Blocks.PURPLE_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_CONCRETE));
    public static final Supplier<Block> PURPLE_CONCRETE_SLAB = MapleBlocks.registerBlock("purple_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPLE_CONCRETE));
    public static final Supplier<Block> BLUE_CONCRETE_STAIRS = MapleBlocks.registerBlock("blue_concrete_stairs", settings -> new StairBlock(Blocks.BLUE_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_CONCRETE));
    public static final Supplier<Block> BLUE_CONCRETE_SLAB = MapleBlocks.registerBlock("blue_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_CONCRETE));
    public static final Supplier<Block> BROWN_CONCRETE_STAIRS = MapleBlocks.registerBlock("brown_concrete_stairs", settings -> new StairBlock(Blocks.BROWN_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_CONCRETE));
    public static final Supplier<Block> BROWN_CONCRETE_SLAB = MapleBlocks.registerBlock("brown_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_CONCRETE));
    public static final Supplier<Block> GREEN_CONCRETE_STAIRS = MapleBlocks.registerBlock("green_concrete_stairs", settings -> new StairBlock(Blocks.GREEN_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CONCRETE));
    public static final Supplier<Block> GREEN_CONCRETE_SLAB = MapleBlocks.registerBlock("green_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CONCRETE));
    public static final Supplier<Block> RED_CONCRETE_STAIRS = MapleBlocks.registerBlock("red_concrete_stairs", settings -> new StairBlock(Blocks.RED_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_CONCRETE));
    public static final Supplier<Block> RED_CONCRETE_SLAB = MapleBlocks.registerBlock("red_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_CONCRETE));
    public static final Supplier<Block> BLACK_CONCRETE_STAIRS = MapleBlocks.registerBlock("black_concrete_stairs", settings -> new StairBlock(Blocks.BLACK_CONCRETE.defaultBlockState(), settings), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CONCRETE));
    public static final Supplier<Block> BLACK_CONCRETE_SLAB = MapleBlocks.registerBlock("black_concrete_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CONCRETE));
    public static final Supplier<Block> Maple_Juicer_Block = MapleBlocks.registerBlock("maple_juicer_block", MapleJuicerBlock::new, BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Supplier<Block> Tea_Block = MapleBlocks.registerBlock("tea_block", MapleTeaBlock::new, BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(3.0f, 3.0f));

    public static <B extends Block> RegistryObject<Block> register(String name, Function<BlockBehaviour.Properties, ? extends B> func, BlockBehaviour.Properties props) {
        return BLOCKS.register(name, () -> (Block)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name)))));
    }

    private static <B extends Block> RegistryObject<Block> registerBlockWithoutItem(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        RegistryObject<Block> register = MapleBlocks.register(name, block, properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name))));
        return register;
    }

    private static <B extends Block> RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        RegistryObject<Block> bRegistryObject = MapleBlocks.registerBlockWithoutItem(name, block, properties);
        MapleBlocks.registerBlockItem(name, bRegistryObject);
        return bRegistryObject;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, Supplier<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name)))));
    }

    private static RotatedPillarBlock createBambooBlock(MapColor topMaterialColor, MapColor sideMaterialColor, SoundType soundGroup) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(sideMaterialColor).strength(2.0f).sound(soundGroup));
    }

    private static BlockBehaviour.Properties buttonProperties() {
        return BlockBehaviour.Properties.of().noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY);
    }

    public static void registerMapleBlocks(BusGroup eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
    }
}

