/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.block.entity;

import com.skniro.maple.block.entity.ImplementedInventory;
import com.skniro.maple.block.entity.MapleBlockEntityType;
import com.skniro.maple.recipe.MapleCraftingRecipeInput;
import com.skniro.maple.recipe.MapleJuicerCraftingRecipe;
import com.skniro.maple.recipe.MapleRecipeType;
import com.skniro.maple.screen.MapleJuicerBlockScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class MapleJuicerBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private float rotation = 0.0f;
    private LazyOptional<? extends IItemHandler>[] lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private static final int INPUT_SLOT = 0;
    private static final int Glass_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int ENERGY_ITEM_SLOT = 3;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> MapleJuicerBlockEntity.this.progress;
                case 1 -> MapleJuicerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    MapleJuicerBlockEntity.this.progress = value;
                }
                case 1: {
                    MapleJuicerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private final int DEFAULT_MAX_PROGRESS = 72;

    public MapleJuicerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MapleBlockEntityType.MAPLE_JUICER_BLOCK_ENTITY_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public ItemStack getRenderStack() {
        return this.getItem(0);
    }

    @Override
    public void setChanged() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.maple.maple_juicer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new MapleJuicerBlockScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void saveAdditional(ValueOutput nbt) {
        super.saveAdditional(nbt);
        ContainerHelper.saveAllItems((ValueOutput)nbt, this.inventory);
        nbt.putInt("maple_juicer.progress", this.progress);
        nbt.putInt("maple_juicer.max_progress", this.maxProgress);
    }

    public void loadAdditional(ValueInput nbt) {
        ContainerHelper.loadAllItems((ValueInput)nbt, this.inventory);
        this.progress = nbt.getInt("maple_juicer.progress").orElse(0);
        this.maxProgress = nbt.getInt("maple_juicer.max_progress").orElse(72);
        super.loadAdditional(nbt);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return;
        }
        if (this.hasRecipe() && this.canInsertIntoOutputSlot()) {
            this.increaseCraftingProgress();
            MapleJuicerBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<RecipeHolder<MapleJuicerCraftingRecipe>> recipe = this.getCurrentRecipe();
        this.removeItem(0, 1);
        this.removeItem(1, 1);
        this.setItem(2, new ItemStack((ItemLike)((MapleJuicerCraftingRecipe)recipe.get().value()).getResult(null).getItem(), this.getItem(2).getCount() + ((MapleJuicerCraftingRecipe)recipe.get().value()).getResult(null).getCount()));
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        int[] nArray;
        switch (direction) {
            case UP: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
                break;
            }
            case DOWN: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
                break;
            }
            default: {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 2;
            }
        }
        return nArray;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot != 2;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canInsertIntoOutputSlot() {
        return this.getItem(2).isEmpty() || this.getItem(2).getCount() < this.getItem(2).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<MapleJuicerCraftingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((MapleJuicerCraftingRecipe)recipe.get().value()).getResult(null);
        return recipe.isPresent() && this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<MapleJuicerCraftingRecipe>> getCurrentRecipe() {
        SimpleContainer inv = new SimpleContainer(this.getContainerSize());
        for (int i = 0; i < this.getContainerSize(); ++i) {
            inv.setItem(i, this.getItem(i));
        }
        return this.getLevel().getServer().getRecipeManager().getRecipeFor((RecipeType)MapleRecipeType.Maple_JUIER_TYPE.get(), (RecipeInput)new MapleCraftingRecipeInput((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1)), this.getLevel());
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.getItem(2).isEmpty() || this.getItem(2).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.getItem(2).isEmpty() ? 1 : this.getItem(2).getMaxStackSize();
        int currentCount = this.getItem(2).getCount();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.remove) {
            return switch (facing) {
                case Direction.DOWN -> this.lazyItemHandler[1].cast();
                default -> this.lazyItemHandler[0].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.lazyItemHandler.length; ++x) {
            this.lazyItemHandler[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    }
}

