/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.block.init;

import com.mojang.serialization.MapCodec;
import com.skniro.maple.state.property.MapleProperties;
import javax.swing.text.html.BlockView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MapleFlowerbedBlock
extends BushBlock
implements BonemealableBlock {
    public static final int field_42762 = 1;
    public static final int field_42763 = 4;
    public static final EnumProperty<Direction> FACING;
    public static final IntegerProperty FLOWER_AMOUNT;
    public static final MapCodec<MapleFlowerbedBlock> CODEC;

    public MapleFlowerbedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)FLOWER_AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)FLOWER_AMOUNT) < 4 || super.canBeReplaced(state, context);
    }

    public VoxelShape getShape(BlockState state, BlockView world, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        return blockState.is((Block)this) ? (BlockState)blockState.setValue((Property)FLOWER_AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.getValue((Property)FLOWER_AMOUNT) + 1))) : (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FLOWER_AMOUNT});
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = (Integer)state.getValue((Property)FLOWER_AMOUNT);
        if (i < 4) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FLOWER_AMOUNT, (Comparable)Integer.valueOf(i + 1)), 2);
        } else {
            MapleFlowerbedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }

    static {
        CODEC = MapleFlowerbedBlock.simpleCodec(MapleFlowerbedBlock::new);
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        FLOWER_AMOUNT = MapleProperties.FLOWER_AMOUNT;
    }
}

