/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.block.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WindowBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<WindowBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WindowBlock.propertiesCodec(), (App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(block -> block.blockSetType)).apply((Applicative)instance, WindowBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<DoorHingeSide> HINGE;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty POWERED;
    public static final VoxelShape WEST_OPEN_SHAPE;
    public static final VoxelShape EAST_OPEN_SHAPE;
    public static final VoxelShape NORTH_OPEN_SHAPE;
    public static final VoxelShape SOUTH_OPEN_SHAPE;
    public static final VoxelShape WEST_CLOSED_SHAPE;
    public static final VoxelShape EAST_CLOSED_SHAPE;
    public static final VoxelShape NORTH_CLOSED_SHAPE;
    public static final VoxelShape SOUTH_CLOSED_SHAPE;
    private final BlockSetType blockSetType;

    public WindowBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings.sound(blockSetType.soundType()));
        this.blockSetType = blockSetType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockSetType getBlockSetType() {
        return this.blockSetType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        boolean closed = (Boolean)state.getValue((Property)OPEN) == false;
        switch (direction) {
            case EAST: {
                return closed ? EAST_CLOSED_SHAPE : EAST_OPEN_SHAPE;
            }
            case SOUTH: {
                return closed ? SOUTH_CLOSED_SHAPE : SOUTH_OPEN_SHAPE;
            }
            case WEST: {
                return closed ? WEST_CLOSED_SHAPE : WEST_OPEN_SHAPE;
            }
        }
        return closed ? NORTH_CLOSED_SHAPE : NORTH_OPEN_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        boolean powered = world.hasNeighborSignal(blockPos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!this.blockSetType.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.cycle((Property)OPEN);
        world.setBlock(pos, state, 10);
        this.playOpenCloseSound((Entity)player, world, pos, (Boolean)state.getValue((Property)OPEN));
        world.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        return InteractionResult.SUCCESS;
    }

    private void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.playSound(entity, pos, open ? this.blockSetType.doorOpen() : this.blockSetType.doorClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HINGE, POWERED});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    static {
        OPEN = BlockStateProperties.OPEN;
        HINGE = BlockStateProperties.DOOR_HINGE;
        POWERED = BlockStateProperties.POWERED;
        WEST_CLOSED_SHAPE = Block.box((double)7.0, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);
        EAST_CLOSED_SHAPE = Block.box((double)7.5, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        NORTH_CLOSED_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)8.5);
        SOUTH_CLOSED_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)9.0);
        WEST_OPEN_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)16.0);
        EAST_OPEN_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5);
        NORTH_OPEN_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0);
        SOUTH_OPEN_SHAPE = Block.box((double)14.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

