/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MapleCampfireSmokeParticle
extends SingleQuadParticle {
    MapleCampfireSmokeParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, boolean signal, TextureAtlasSprite sprite) {
        super(world, x, y, z, sprite);
        this.scale(1.0f);
        this.setSize(0.25f, 0.25f);
        this.lifetime = signal ? this.random.nextInt(50) + 280 : this.random.nextInt(50) + 80;
        this.gravity = 3.0E-6f;
        this.xd = velocityX;
        this.yd = velocityY + (double)(this.random.nextFloat() / 500.0f);
        this.zd = velocityZ;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CosySmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public CosySmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, RandomSource random) {
            MapleCampfireSmokeParticle campfireSmokeParticle = new MapleCampfireSmokeParticle(clientWorld, d, e, f, g, h, i, false, this.spriteProvider.get(random));
            campfireSmokeParticle.setAlpha(0.7f);
            return campfireSmokeParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SignalSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public SignalSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, RandomSource random) {
            MapleCampfireSmokeParticle campfireSmokeParticle = new MapleCampfireSmokeParticle(clientWorld, d, e, f, g, h, i, true, this.spriteProvider.get(random));
            campfireSmokeParticle.setAlpha(0.95f);
            return campfireSmokeParticle;
        }
    }
}

