/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MapleCherryLeavesParticle
extends SingleQuadParticle {
    private static final float field_43372 = 0.0025f;
    private static final int field_43373 = 300;
    private static final int field_43366 = 300;
    private static final float field_43367 = 0.25f;
    private static final float field_43368 = 2.0f;
    private float field_43369;
    private final float field_43370;
    private final float field_43371;

    public MapleCherryLeavesParticle(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider, TextureAtlasSprite sprite) {
        super(world, x, y, z, sprite);
        float f;
        this.setSprite(spriteProvider.get(this.random.nextInt(12), 12));
        this.field_43369 = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.field_43370 = this.random.nextFloat();
        this.field_43371 = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.lifetime = 300;
        this.gravity = 7.5E-4f;
        this.quadSize = f = this.random.nextBoolean() ? 0.05f : 0.075f;
        this.setSize(f, f);
        this.friction = 1.0f;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            float f = 300 - this.lifetime;
            float g = Math.min(f / 300.0f, 1.0f);
            double d = Math.cos(Math.toRadians(this.field_43370 * 60.0f)) * 2.0 * Math.pow(g, 1.25);
            double e = Math.sin(Math.toRadians(this.field_43370 * 60.0f)) * 2.0 * Math.pow(g, 1.25);
            this.xd += d * (double)0.0025f;
            this.zd += e * (double)0.0025f;
            this.yd -= (double)this.gravity;
            this.field_43369 += this.field_43371 / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.field_43369 / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }
}

