/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.entity;

import com.skniro.maple.entity.furniture.ChairEntity;
import com.skniro.maple.entity.furniture.CushionEntity;
import com.skniro.maple.item.MapleItems;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MapleEntityType {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"maple");
    public static final RegistryObject<EntityType<ChairEntity>> CHAIR_ENTITY = ENTITY_TYPES.register("chair_entity", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).build(MapleEntityType.keyOf("chair_entity")));
    public static final RegistryObject<EntityType<CushionEntity>> Cushion_ENTITY = ENTITY_TYPES.register("cushion_entity", () -> EntityType.Builder.of(CushionEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).build(MapleEntityType.keyOf("cushion_entity")));
    public static final RegistryObject<EntityType<Boat>> Maple_BOAT = ENTITY_TYPES.register("maple_boat", () -> EntityType.Builder.of(MapleEntityType.getBoatFactory(() -> (Item)MapleItems.MAPLE_BOAT.get()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(MapleEntityType.keyOf("maple_boat")));
    public static final RegistryObject<EntityType<ChestBoat>> Maple_CHEST_BOAT = ENTITY_TYPES.register("maple_chest_boat", () -> EntityType.Builder.of(MapleEntityType.getChestBoatFactory(() -> (Item)MapleItems.MAPLE_CHEST_BOAT.get()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(MapleEntityType.keyOf("maple_chest_boat")));
    public static final RegistryObject<EntityType<Boat>> GINKGO_BOAT = ENTITY_TYPES.register("ginkgo_boat", () -> EntityType.Builder.of(MapleEntityType.getBoatFactory(() -> (Item)MapleItems.MAPLE_BOAT.get()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(MapleEntityType.keyOf("ginkgo_boat")));
    public static final RegistryObject<EntityType<ChestBoat>> GINKGO_CHEST_BOAT = ENTITY_TYPES.register("ginkgo_chest_boat", () -> EntityType.Builder.of(MapleEntityType.getChestBoatFactory(() -> (Item)MapleItems.MAPLE_CHEST_BOAT.get()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(MapleEntityType.keyOf("ginkgo_chest_boat")));

    private static ResourceKey<EntityType<?>> keyOf(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name));
    }

    private static EntityType.EntityFactory<Boat> getBoatFactory(Supplier<Item> itemSupplier) {
        return (type, world) -> new Boat(type, world, itemSupplier);
    }

    private static EntityType.EntityFactory<ChestBoat> getChestBoatFactory(Supplier<Item> itemSupplier) {
        return (type, world) -> new ChestBoat(type, world, itemSupplier);
    }

    public static void register(BusGroup eventBus) {
        ENTITY_TYPES.register(eventBus);
    }
}

