/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.fluid;

import com.skniro.maple.fluid.MapleFluids;
import com.skniro.maple.fluid.init.MapleHotSpringFluidBlock;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MapleFluidBlockOrItem {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"maple");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"maple");
    public static Supplier<Block> Hot_Spring_BLOCK = MapleFluidBlockOrItem.registerBlock("hot_spring_block", properties -> new MapleHotSpringFluidBlock(MapleFluids.STILL_Hot_Spring, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.WATER).lightLevel(state -> 8));
    public static Supplier<Item> Hot_Spring_BUCKET = MapleFluidBlockOrItem.registerItem("hot_spring_bucket", properties -> new BucketItem(MapleFluids.STILL_Hot_Spring, properties), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1));

    public static <B extends Block> RegistryObject<Block> register(String name, Function<BlockBehaviour.Properties, ? extends B> func, BlockBehaviour.Properties props) {
        return BLOCKS.register(name, () -> (Block)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name)))));
    }

    private static <B extends Block> RegistryObject<Block> registerBlockWithoutItem(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        RegistryObject<Block> register = MapleFluidBlockOrItem.register(name, block, properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name))));
        return register;
    }

    private static <B extends Block> RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        RegistryObject<Block> bRegistryObject = MapleFluidBlockOrItem.registerBlockWithoutItem(name, block, properties);
        MapleFluidBlockOrItem.registerBlockItem(name, bRegistryObject);
        return bRegistryObject;
    }

    public static <B extends Item> RegistryObject<Item> register(String name, Function<Item.Properties, ? extends B> func, Item.Properties props) {
        return ITEMS.register(name, () -> (Item)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name)))));
    }

    private static <T extends Item> RegistryObject<Item> registerItem(String name, Function<Item.Properties, ? extends T> item, Item.Properties properties) {
        RegistryObject<Item> toReturn = MapleFluidBlockOrItem.register(name, item, properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name))));
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, Supplier<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"maple", (String)name)))));
    }

    public static void registerFluidItems(BusGroup eventBus) {
        ITEMS.register(eventBus);
    }

    public static void registerFluidBlocks(BusGroup eventBus) {
        BLOCKS.register(eventBus);
    }
}

