/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.fluid.init;

import com.skniro.maple.fluid.MapleFluidBlockOrItem;
import com.skniro.maple.fluid.MapleFluids;
import com.skniro.maple.particle.MapleParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapleHotSpringFluid
extends FlowingFluid {
    protected boolean canConvertToSource(ServerLevel level) {
        return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    public void animateTick(Level world, BlockPos pos, @NotNull FluidState state, RandomSource random) {
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            world.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (random.nextFloat() < 0.07f) {
            world.addParticle((ParticleOptions)MapleParticleTypes.HOT_SPRING.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.03, 0.0);
        }
    }

    protected int getSlopeFindDistance(LevelReader world) {
        return 4;
    }

    protected int getDropOff(LevelReader world) {
        return 1;
    }

    public boolean isSame(Fluid fluid) {
        return fluid == this.getSource() || fluid == this.getFlowing();
    }

    public int getAmount(FluidState state) {
        return 0;
    }

    public FluidType getFluidType() {
        return (FluidType)ForgeMod.WATER_TYPE.get();
    }

    public int getTickDelay(LevelReader world) {
        return 5;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Nullable
    protected ParticleOptions getDripParticle() {
        return null;
    }

    protected boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return false;
    }

    public Fluid getSource() {
        return (Fluid)MapleFluids.STILL_Hot_Spring.get();
    }

    public Fluid getFlowing() {
        return (Fluid)MapleFluids.FLOWING_Hot_Spring.get();
    }

    public Item getBucket() {
        return MapleFluidBlockOrItem.Hot_Spring_BUCKET.get();
    }

    protected BlockState createLegacyBlock(FluidState state) {
        return (BlockState)MapleFluidBlockOrItem.Hot_Spring_BLOCK.get().defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(MapleHotSpringFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSource(FluidState state) {
        return false;
    }

    public static class Still
    extends MapleHotSpringFluid {
        @Override
        public int getAmount(FluidState state) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends MapleHotSpringFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        @Override
        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        @Override
        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

