/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.maple.recipe.MapleRecipeType;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MapleJuicerCraftingRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    final List<Ingredient> recipeItems;
    @Nullable
    private PlacementInfo ingredientPlacement;

    public MapleJuicerCraftingRecipe(List<Ingredient> recipeItems, ItemStack output) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(RecipeInput inventory, Level world) {
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            if (this.recipeItems.get(i).test(inventory.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeInput inventory, HolderLookup.Provider lookup) {
        return this.output;
    }

    public PlacementInfo placementInfo() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = PlacementInfo.create(this.recipeItems);
        }
        return this.ingredientPlacement;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public ItemStack getResult(HolderLookup.Provider lookup) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.createWithCapacity((int)2);
        list.addAll(this.recipeItems);
        return list;
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return (RecipeSerializer)MapleRecipeType.Maple_JUIER_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return (RecipeType)MapleRecipeType.Maple_JUIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<MapleJuicerCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<MapleJuicerCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.listOf().fieldOf("ingredient").forGetter(recipe -> recipe.recipeItems), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)inst, MapleJuicerCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MapleJuicerCraftingRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<MapleJuicerCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MapleJuicerCraftingRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        private static MapleJuicerCraftingRecipe read(RegistryFriendlyByteBuf buf) {
            int i = buf.readVarInt();
            NonNullList defaultedList = NonNullList.withSize((int)i, (Object)Ingredient.of((ItemLike)ItemStack.EMPTY.getItem()));
            defaultedList.replaceAll(empty -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new MapleJuicerCraftingRecipe((List<Ingredient>)defaultedList, itemStack);
        }

        private static void write(RegistryFriendlyByteBuf buf, MapleJuicerCraftingRecipe recipe) {
            buf.writeVarInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.output);
        }
    }
}

