/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.screen;

import com.skniro.maple.block.entity.MapleJuicerBlockEntity;
import com.skniro.maple.screen.MapleScreenHandlerType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MapleJuicerBlockScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData propertyDelegate;
    public final MapleJuicerBlockEntity blockEntity;

    public MapleJuicerBlockScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, playerInventory.player.level().getBlockEntity(packetByteBuf.readBlockPos()), (ContainerData)new SimpleContainerData(3));
    }

    public MapleJuicerBlockScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity, ContainerData delegate) {
        super((MenuType)MapleScreenHandlerType.Maple_JUICER.get(), syncId);
        MapleJuicerBlockScreenHandler.checkContainerSize((Container)((Container)blockEntity), (int)3);
        this.inventory = (Container)blockEntity;
        this.inventory.startOpen((ContainerUser)playerInventory.player);
        this.propertyDelegate = delegate;
        this.blockEntity = (MapleJuicerBlockEntity)blockEntity;
        this.addSlot(new Slot(this.inventory, 0, 52, 19));
        this.addSlot(new Slot(this.inventory, 1, 52, 50));
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, this.inventory, 2, 100, 34));
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addDataSlots(delegate);
    }

    public boolean isCrafting() {
        return this.propertyDelegate.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.propertyDelegate.get(0);
        int maxProgress = this.propertyDelegate.get(1);
        int progressArrowSize = 27;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

