/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.world.biome;

import com.skniro.maple.world.feature.MapleBiomeFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class MapleOverworldBiomes {
    public static Biome createMapleGrove(HolderGetter<PlacedFeature> featureLookup, HolderGetter<ConfiguredWorldCarver<?>> carverLookup) {
        BiomeGenerationSettings.Builder lookupBackedBuilder = new BiomeGenerationSettings.Builder(featureLookup, carverLookup);
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)builder);
        MapleOverworldBiomes.addBasicFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        lookupBackedBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        MapleBiomeFeatures.addMapleGroveFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)lookupBackedBuilder, (boolean)false);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)builder);
        Music musicSound = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_MEADOW);
        return MapleOverworldBiomes.createBiome(true, 0.5f, 0.8f, 4159204, 329011, 0xCC9933, 11983713, builder, (BiomeGenerationSettings.PlainBuilder)lookupBackedBuilder, musicSound);
    }

    public static Biome createSakura(HolderGetter<PlacedFeature> featureLookup, HolderGetter<ConfiguredWorldCarver<?>> carverLookup) {
        BiomeGenerationSettings.Builder lookupBackedBuilder = new BiomeGenerationSettings.Builder(featureLookup, carverLookup);
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        builder.addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.PIG, 1, 2)).addSpawn(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 6)).addSpawn(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 2, 4));
        MapleOverworldBiomes.addBasicFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        lookupBackedBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
        MapleBiomeFeatures.addSakuraFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)lookupBackedBuilder, (boolean)false);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        Music musicSound = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_MEADOW);
        return MapleOverworldBiomes.createBiome(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, builder, (BiomeGenerationSettings.PlainBuilder)lookupBackedBuilder, musicSound);
    }

    private static void addBasicFeatures(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)generationSettings);
    }

    protected static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = Mth.clamp((float)f, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    private static Biome createBiome(boolean precipitation, float temperature, float downfall, MobSpawnSettings.Builder spawnSettings, BiomeGenerationSettings.PlainBuilder generationSettings, @Nullable Music music) {
        return MapleOverworldBiomes.createBiome(precipitation, temperature, downfall, 4159204, 329011, null, null, spawnSettings, generationSettings, music);
    }

    private static Biome createBiome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, @Nullable Integer grassColor, @Nullable Integer foliageColor, MobSpawnSettings.Builder spawnSettings, BiomeGenerationSettings.PlainBuilder generationSettings, @Nullable Music music) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder().waterColor(waterColor).waterFogColor(waterFogColor).fogColor(12638463).skyColor(MapleOverworldBiomes.getSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music);
        if (grassColor != null) {
            builder.grassColorOverride(grassColor.intValue());
        }
        if (foliageColor != null) {
            builder.foliageColorOverride(foliageColor.intValue());
        }
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(downfall).specialEffects(builder.build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }
}

