/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.world.biome;

import com.mojang.datafixers.util.Pair;
import com.skniro.maple.world.biome.MapleBiomeKeys;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class MapleSakuraBiome
extends Region {
    public MapleSakuraBiome(ResourceLocation name, int weight) {
        super(name, RegionType.OVERWORLD, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            builder.replaceBiome(Biomes.MEADOW, MapleBiomeKeys.Sakura);
            new ParameterUtils.ParameterPointListBuilder().temperature(new Climate.Parameter[]{ParameterUtils.Temperature.span((ParameterUtils.Temperature)ParameterUtils.Temperature.COOL, (ParameterUtils.Temperature)ParameterUtils.Temperature.WARM)}).humidity(new Climate.Parameter[]{ParameterUtils.Humidity.span((ParameterUtils.Humidity)ParameterUtils.Humidity.NEUTRAL, (ParameterUtils.Humidity)ParameterUtils.Humidity.WET)}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.INLAND}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.EROSION_0, ParameterUtils.Erosion.EROSION_1}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.SURFACE, ParameterUtils.Depth.FLOOR}).weirdness(new Climate.Parameter[]{ParameterUtils.Weirdness.span((ParameterUtils.Weirdness)ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_ASCENDING, (ParameterUtils.Weirdness)ParameterUtils.Weirdness.PEAK_VARIANT)}).build().forEach(point -> builder.replaceBiome(point, MapleBiomeKeys.Sakura));
            builder.build().forEach(mapper::accept);
        });
    }
}

