/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple;

import com.mojang.logging.LogUtils;
import com.skniro.maple.block.MapleBlocks;
import com.skniro.maple.block.MapleFurnitureBlocks;
import com.skniro.maple.block.MapleOreBlocks;
import com.skniro.maple.block.MapleSignBlocks;
import com.skniro.maple.block.entity.MapleBlockEntities;
import com.skniro.maple.block.entity.MapleBlockEntityType;
import com.skniro.maple.block.entity.MapleWoodTypes;
import com.skniro.maple.block.renderer.MapleJuicerEntityRenderer;
import com.skniro.maple.client.boat.MapleModelLayers;
import com.skniro.maple.client.gui.screen.ingame.MapleJuicerBlockScreen;
import com.skniro.maple.client.particle.MapleCampfireSmokeParticle;
import com.skniro.maple.client.particle.MapleCherryLeavesParticle;
import com.skniro.maple.client.renderer.ChairRenderer;
import com.skniro.maple.client.renderer.CushinoRenderer;
import com.skniro.maple.entity.MapleEntityType;
import com.skniro.maple.fluid.MapleFluidBlockOrItem;
import com.skniro.maple.fluid.MapleFluidTypes;
import com.skniro.maple.fluid.MapleFluids;
import com.skniro.maple.item.GlassCupItems;
import com.skniro.maple.item.MapleArmorItems;
import com.skniro.maple.item.MapleCreativeModeTabs;
import com.skniro.maple.item.MapleFoodComponents;
import com.skniro.maple.item.MapleItems;
import com.skniro.maple.particle.MapleParticleTypes;
import com.skniro.maple.recipe.MapleRecipeType;
import com.skniro.maple.screen.MapleScreenHandlerType;
import com.skniro.maple.util.MapleLootModifiers;
import com.skniro.maple.world.biome.MapleTerrablender;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="maple")
public class Maple {
    public static final String MOD_ID = "maple";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Maple(FMLJavaModLoadingContext context) {
        BusGroup modEventBus = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modEventBus).addListener(this::commonSetup);
        MapleBlocks.registerMapleBlocks(modEventBus);
        MapleOreBlocks.registerMapleOreBlocks(modEventBus);
        MapleFurnitureBlocks.registerMapleBlocks(modEventBus);
        MapleBlockEntityType.registerBlockEntityType(modEventBus);
        MapleItems.registerModItems(modEventBus);
        GlassCupItems.registerMapleGlassItems(modEventBus);
        MapleFoodComponents.registerModFoodItems(modEventBus);
        MapleArmorItems.registerMapleArmorItems(modEventBus);
        MapleFluids.registerFluids(modEventBus);
        MapleFluidBlockOrItem.registerFluidBlocks(modEventBus);
        MapleFluidBlockOrItem.registerFluidItems(modEventBus);
        MapleCreativeModeTabs.registerMapleCreativeModeTabs(modEventBus);
        MapleSignBlocks.registerMapleSignBlocks(modEventBus);
        MapleBlockEntities.registerMapleBlockEntities(modEventBus);
        MapleEntityType.register(modEventBus);
        MapleScreenHandlerType.registerMapleScreenHandlerType(modEventBus);
        MapleRecipeType.registerRecipes(modEventBus);
        MapleFluidTypes.register(modEventBus);
        MapleParticleTypes.MapleParticleTypesRegister(modEventBus);
        MapleLootModifiers.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(MapleTerrablender::registerBiomes);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="maple", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ParticleFactoryRegistry {
        @SubscribeEvent
        public static void onParticleFactoryRegistration(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)MapleParticleTypes.HOT_SPRING.get(), MapleCampfireSmokeParticle.CosySmokeFactory::new);
            event.registerSpriteSet((ParticleType)MapleParticleTypes.CHERRY_LEAVES.get(), spriteProvider -> (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new MapleCherryLeavesParticle(world, x, y, z, spriteProvider));
            event.registerSpriteSet((ParticleType)MapleParticleTypes.SAKURA_LEAVES.get(), spriteProvider -> (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new MapleCherryLeavesParticle(world, x, y, z, spriteProvider));
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)MapleEntityType.Maple_BOAT.get()), pContext -> new BoatRenderer(pContext, MapleModelLayers.Maple_BOAT_LAYER));
            EntityRenderers.m_174036_((EntityType)((EntityType)MapleEntityType.Maple_CHEST_BOAT.get()), pContext -> new BoatRenderer(pContext, MapleModelLayers.Maple_CHEST_BOAT_LAYER));
            EntityRenderers.m_174036_((EntityType)((EntityType)MapleEntityType.GINKGO_BOAT.get()), pContext -> new BoatRenderer(pContext, MapleModelLayers.Ginkgo_BOAT_LAYER));
            EntityRenderers.m_174036_((EntityType)((EntityType)MapleEntityType.GINKGO_CHEST_BOAT.get()), pContext -> new BoatRenderer(pContext, MapleModelLayers.Ginkgo_CHEST_BOAT_LAYER));
            event.registerLayerDefinition(MapleModelLayers.Maple_BOAT_LAYER, BoatModel::m_356210_);
            event.registerLayerDefinition(MapleModelLayers.Maple_CHEST_BOAT_LAYER, BoatModel::m_355977_);
            event.registerLayerDefinition(MapleModelLayers.Ginkgo_BOAT_LAYER, BoatModel::m_356210_);
            event.registerLayerDefinition(MapleModelLayers.Ginkgo_CHEST_BOAT_LAYER, BoatModel::m_355977_);
        }
    }

    @Mod.EventBusSubscriber(modid="maple", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            WoodType.m_61844_((WoodType)MapleWoodTypes.MAPLE);
            WoodType.m_61844_((WoodType)MapleWoodTypes.GINKGO);
            BlockEntityRenderers.m_173590_(MapleBlockEntities.SIGN_BLOCK_ENTITIES.get(), SignRenderer::new);
            BlockEntityRenderers.m_173590_(MapleBlockEntities.Maple_HANGING_SIGN.get(), HangingSignRenderer::new);
            Sheets.addWoodType((WoodType)MapleWoodTypes.MAPLE);
            Sheets.addWoodType((WoodType)MapleWoodTypes.GINKGO);
            EntityRenderers.m_174036_((EntityType)((EntityType)MapleEntityType.Cushion_ENTITY.get()), CushinoRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)MapleEntityType.CHAIR_ENTITY.get()), ChairRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MapleScreenHandlerType.Maple_JUICER.get()), MapleJuicerBlockScreen::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)MapleBlockEntityType.MAPLE_JUICER_BLOCK_ENTITY_BLOCK_ENTITY_TYPE.get()), MapleJuicerEntityRenderer::new);
        }
    }
}

