/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.block.entity;

import com.skniro.maple.block.entity.ImplementedInventory;
import com.skniro.maple.block.entity.MapleBlockEntityType;
import com.skniro.maple.recipe.MapleCraftingRecipeInput;
import com.skniro.maple.recipe.MapleJuicerCraftingRecipe;
import com.skniro.maple.recipe.MapleRecipeType;
import com.skniro.maple.screen.MapleJuicerBlockScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class MapleJuicerBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private float rotation = 0.0f;
    private LazyOptional<? extends IItemHandler>[] lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private static final int INPUT_SLOT = 0;
    private static final int Glass_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int ENERGY_ITEM_SLOT = 3;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MapleJuicerBlockEntity.this.progress;
                case 1 -> MapleJuicerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MapleJuicerBlockEntity.this.progress = value;
                }
                case 1: {
                    MapleJuicerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private final int DEFAULT_MAX_PROGRESS = 72;

    public MapleJuicerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MapleBlockEntityType.MAPLE_JUICER_BLOCK_ENTITY_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public ItemStack getRenderStack() {
        return this.m_8020_(0);
    }

    @Override
    public void m_6596_() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.maple.maple_juicer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new MapleJuicerBlockScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void m_183515_(ValueOutput nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18976_((ValueOutput)nbt, this.inventory);
        nbt.m_402823_("maple_juicer.progress", this.progress);
        nbt.m_402823_("maple_juicer.max_progress", this.maxProgress);
    }

    public void m_318667_(ValueInput nbt) {
        ContainerHelper.m_18980_((ValueInput)nbt, this.inventory);
        this.progress = nbt.m_402201_("maple_juicer.progress").orElse(0);
        this.maxProgress = nbt.m_402201_("maple_juicer.max_progress").orElse(72);
        super.m_318667_(nbt);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.m_5776_()) {
            return;
        }
        if (this.hasRecipe() && this.canInsertIntoOutputSlot()) {
            this.increaseCraftingProgress();
            MapleJuicerBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<RecipeHolder<MapleJuicerCraftingRecipe>> recipe = this.getCurrentRecipe();
        this.m_7407_(0, 1);
        this.m_7407_(1, 1);
        this.m_6836_(2, new ItemStack((ItemLike)((MapleJuicerCraftingRecipe)recipe.get().f_291008_()).getResult(null).m_41720_(), this.m_8020_(2).m_41613_() + ((MapleJuicerCraftingRecipe)recipe.get().f_291008_()).getResult(null).m_41613_()));
    }

    @Override
    public int[] m_7071_(Direction direction) {
        int[] nArray;
        switch (direction) {
            case UP: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
                break;
            }
            case DOWN: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
                break;
            }
            default: {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 2;
            }
        }
        return nArray;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot != 2;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canInsertIntoOutputSlot() {
        return this.m_8020_(2).m_41619_() || this.m_8020_(2).m_41613_() < this.m_8020_(2).m_41741_();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<MapleJuicerCraftingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((MapleJuicerCraftingRecipe)recipe.get().f_291008_()).getResult(null);
        return recipe.isPresent() && this.canInsertAmountIntoOutputSlot(output.m_41613_()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<MapleJuicerCraftingRecipe>> getCurrentRecipe() {
        SimpleContainer inv = new SimpleContainer(this.m_6643_());
        for (int i = 0; i < this.m_6643_(); ++i) {
            inv.m_6836_(i, this.m_8020_(i));
        }
        return this.m_58904_().m_7654_().m_129894_().m_44015_((RecipeType)MapleRecipeType.Maple_JUIER_TYPE.get(), (RecipeInput)new MapleCraftingRecipeInput((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1)), this.m_58904_());
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.m_8020_(2).m_41619_() || this.m_8020_(2).m_41720_() == output.m_41720_();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.m_8020_(2).m_41619_() ? 1 : this.m_8020_(2).m_41741_();
        int currentCount = this.m_8020_(2).m_41613_();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_(HolderLookup.Provider registryLookup) {
        return this.m_187482_(registryLookup);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.f_58859_) {
            return switch (facing) {
                case Direction.DOWN -> this.lazyItemHandler[1].cast();
                default -> this.lazyItemHandler[0].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.lazyItemHandler.length; ++x) {
            this.lazyItemHandler[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    }
}

