/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.block.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WindowBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<WindowBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WindowBlock.m_305607_(), (App)BlockSetType.f_303023_.fieldOf("block_set_type").forGetter(block -> block.blockSetType)).apply((Applicative)instance, WindowBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoorHingeSide> HINGE;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty POWERED;
    public static final VoxelShape WEST_OPEN_SHAPE;
    public static final VoxelShape EAST_OPEN_SHAPE;
    public static final VoxelShape NORTH_OPEN_SHAPE;
    public static final VoxelShape SOUTH_OPEN_SHAPE;
    public static final VoxelShape WEST_CLOSED_SHAPE;
    public static final VoxelShape EAST_CLOSED_SHAPE;
    public static final VoxelShape NORTH_CLOSED_SHAPE;
    public static final VoxelShape SOUTH_CLOSED_SHAPE;
    private final BlockSetType blockSetType;

    public WindowBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings.m_60918_(blockSetType.f_271136_()));
        this.blockSetType = blockSetType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockSetType getBlockSetType() {
        return this.blockSetType;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_(FACING);
        boolean closed = (Boolean)state.m_61143_((Property)OPEN) == false;
        switch (direction) {
            case EAST: {
                return closed ? EAST_CLOSED_SHAPE : EAST_OPEN_SHAPE;
            }
            case SOUTH: {
                return closed ? SOUTH_CLOSED_SHAPE : SOUTH_OPEN_SHAPE;
            }
            case WEST: {
                return closed ? WEST_CLOSED_SHAPE : WEST_OPEN_SHAPE;
            }
        }
        return closed ? NORTH_CLOSED_SHAPE : NORTH_OPEN_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        boolean powered = world.m_276867_(blockPos);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
    }

    protected InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!this.blockSetType.f_278463_()) {
            return InteractionResult.f_19070_;
        }
        state = (BlockState)state.m_61122_((Property)OPEN);
        world.m_7731_(pos, state, 10);
        this.playOpenCloseSound((Entity)player, world, pos, (Boolean)state.m_61143_((Property)OPEN));
        world.m_142346_((Entity)player, (Holder)((Boolean)state.m_61143_((Property)OPEN) != false ? GameEvent.f_157796_ : GameEvent.f_157793_), pos);
        return InteractionResult.f_19068_;
    }

    private void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.m_5594_(entity, pos, open ? this.blockSetType.f_271141_() : this.blockSetType.f_271502_(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE, POWERED});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> m_304657_() {
        return CODEC;
    }

    static {
        OPEN = BlockStateProperties.f_61446_;
        HINGE = BlockStateProperties.f_61394_;
        POWERED = BlockStateProperties.f_61448_;
        WEST_CLOSED_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);
        EAST_CLOSED_SHAPE = Block.m_49796_((double)7.5, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        NORTH_CLOSED_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)8.5);
        SOUTH_CLOSED_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)9.0);
        WEST_OPEN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)16.0);
        EAST_OPEN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5);
        NORTH_OPEN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0);
        SOUTH_OPEN_SHAPE = Block.m_49796_((double)14.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

