/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.maple.recipe.MapleRecipeType;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MapleJuicerCraftingRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    final List<Ingredient> recipeItems;
    @Nullable
    private PlacementInfo ingredientPlacement;

    public MapleJuicerCraftingRecipe(List<Ingredient> recipeItems, ItemStack output) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean m_5818_(RecipeInput inventory, Level world) {
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            if (this.recipeItems.get(i).test(inventory.m_338719_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(RecipeInput inventory, HolderLookup.Provider lookup) {
        return this.output;
    }

    public PlacementInfo m_351808_() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = PlacementInfo.m_356287_(this.recipeItems);
        }
        return this.ingredientPlacement;
    }

    public RecipeBookCategory m_351608_() {
        return null;
    }

    public ItemStack getResult(HolderLookup.Provider lookup) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.m_182647_((int)2);
        list.addAll(this.recipeItems);
        return list;
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> m_7707_() {
        return (RecipeSerializer)MapleRecipeType.Maple_JUIER_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<RecipeInput>> m_6671_() {
        return (RecipeType)MapleRecipeType.Maple_JUIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<MapleJuicerCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<MapleJuicerCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.f_291570_.listOf().fieldOf("ingredient").forGetter(recipe -> recipe.recipeItems), (App)ItemStack.f_41582_.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)inst, MapleJuicerCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MapleJuicerCraftingRecipe> PACKET_CODEC = StreamCodec.m_320617_(Serializer::write, Serializer::read);

        public MapCodec<MapleJuicerCraftingRecipe> m_292673_() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MapleJuicerCraftingRecipe> m_318841_() {
            return PACKET_CODEC;
        }

        private static MapleJuicerCraftingRecipe read(RegistryFriendlyByteBuf buf) {
            int i = buf.m_130242_();
            NonNullList defaultedList = NonNullList.m_122780_((int)i, (Object)Ingredient.m_43927_((ItemLike)ItemStack.f_41583_.m_41720_()));
            defaultedList.replaceAll(empty -> (Ingredient)Ingredient.f_317040_.m_318688_((Object)buf));
            ItemStack itemStack = (ItemStack)ItemStack.f_315801_.m_318688_((Object)buf);
            return new MapleJuicerCraftingRecipe((List<Ingredient>)defaultedList, itemStack);
        }

        private static void write(RegistryFriendlyByteBuf buf, MapleJuicerCraftingRecipe recipe) {
            buf.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.f_317040_.m_318638_((Object)buf, (Object)ingredient);
            }
            ItemStack.f_315801_.m_318638_((Object)buf, (Object)recipe.output);
        }
    }
}

