/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.world.biome;

import com.skniro.maple.world.feature.MapleBiomeFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class MapleOverworldBiomes {
    public static Biome createMapleGrove(HolderGetter<PlacedFeature> featureLookup, HolderGetter<ConfiguredWorldCarver<?>> carverLookup) {
        BiomeGenerationSettings.Builder lookupBackedBuilder = new BiomeGenerationSettings.Builder(featureLookup, carverLookup);
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)builder);
        MapleOverworldBiomes.addBasicFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        lookupBackedBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195416_);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        MapleBiomeFeatures.addMapleGroveFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)lookupBackedBuilder, (boolean)false);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)builder);
        Music musicSound = Musics.m_263184_((Holder)SoundEvents.f_184223_);
        return MapleOverworldBiomes.createBiome(true, 0.5f, 0.8f, 4159204, 329011, 0xCC9933, 11983713, builder, (BiomeGenerationSettings.PlainBuilder)lookupBackedBuilder, musicSound);
    }

    public static Biome createSakura(HolderGetter<PlacedFeature> featureLookup, HolderGetter<ConfiguredWorldCarver<?>> carverLookup) {
        BiomeGenerationSettings.Builder lookupBackedBuilder = new BiomeGenerationSettings.Builder(featureLookup, carverLookup);
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        builder.m_48376_(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 1, 2)).m_48376_(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 2, 6)).m_48376_(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 2, 4));
        MapleOverworldBiomes.addBasicFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        lookupBackedBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195416_);
        MapleBiomeFeatures.addSakuraFeatures(lookupBackedBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)lookupBackedBuilder, (boolean)false);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)lookupBackedBuilder);
        Music musicSound = Musics.m_263184_((Holder)SoundEvents.f_184223_);
        return MapleOverworldBiomes.createBiome(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, builder, (BiomeGenerationSettings.PlainBuilder)lookupBackedBuilder, musicSound);
    }

    private static void addBasicFeatures(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generationSettings);
    }

    protected static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = Mth.m_14036_((float)f, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    private static Biome createBiome(boolean precipitation, float temperature, float downfall, MobSpawnSettings.Builder spawnSettings, BiomeGenerationSettings.PlainBuilder generationSettings, @Nullable Music music) {
        return MapleOverworldBiomes.createBiome(precipitation, temperature, downfall, 4159204, 329011, null, null, spawnSettings, generationSettings, music);
    }

    private static Biome createBiome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, @Nullable Integer grassColor, @Nullable Integer foliageColor, MobSpawnSettings.Builder spawnSettings, BiomeGenerationSettings.PlainBuilder generationSettings, @Nullable Music music) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(MapleOverworldBiomes.getSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music);
        if (grassColor != null) {
            builder.m_48045_(grassColor.intValue());
        }
        if (foliageColor != null) {
            builder.m_48043_(foliageColor.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(downfall).m_47603_(builder.m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }
}

