/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.maple.world.feature;

import com.skniro.maple.block.MapleBlocks;
import com.skniro.maple.block.MapleOreBlocks;
import com.skniro.maple.block.init.MapleTeaBlock;
import com.skniro.maple.fluid.MapleFluidBlockOrItem;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class MapleConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> Maple_TREE = MapleConfiguredFeatures.registerKey("maple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Red_Maple_TREE = MapleConfiguredFeatures.registerKey("red_maple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHERRY_TREE = MapleConfiguredFeatures.registerKey("cherry_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAKURA_TREE = MapleConfiguredFeatures.registerKey("sakura_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGE_SAKURA_TREE = MapleConfiguredFeatures.registerKey("mage_sakura_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GINKGO_TREE = MapleConfiguredFeatures.registerKey("ginkgo_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SALT_ORE = MapleConfiguredFeatures.registerKey("salt_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LAKE_HOT_SPRING = MapleConfiguredFeatures.registerKey("lake_hot_spring");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Coal_ORE_KEY = MapleConfiguredFeatures.registerKey("coal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Copper_KEY = MapleConfiguredFeatures.registerKey("copper_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Diamond_KEY = MapleConfiguredFeatures.registerKey("diamond_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Emerald_KEY = MapleConfiguredFeatures.registerKey("emerald_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Gold_KEY = MapleConfiguredFeatures.registerKey("gold_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Iron_KEY = MapleConfiguredFeatures.registerKey("iron_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Lapis_KEY = MapleConfiguredFeatures.registerKey("lapis_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Nether_Redstone_ORE_KEY = MapleConfiguredFeatures.registerKey("redstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Sakura_Carpet_KEY = MapleConfiguredFeatures.registerKey("sakura_carpet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Maple_Carpet_KEY = MapleConfiguredFeatures.registerKey("maple_carpet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> Red_Maple_Carpet_KEY = MapleConfiguredFeatures.registerKey("red_maple_carpet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TEA = MapleConfiguredFeatures.registerKey("patch_tea");

    private static TreeConfiguration.TreeConfigurationBuilder builder(Block log, Block leaves, int baseHeight, int firstRandomHeight, int secondRandomHeight, int radius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, firstRandomHeight, secondRandomHeight), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)radius), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder maple() {
        return MapleConfiguredFeatures.builder(MapleBlocks.MAPLE_LOG.get(), MapleBlocks.MAPLE_LEAVES.get(), 4, 2, 0, 2).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder redmaple() {
        return MapleConfiguredFeatures.builder(MapleBlocks.MAPLE_LOG.get(), MapleBlocks.RED_MAPLE_LEAVES.get(), 4, 3, 0, 2).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder cherry() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_271170_), (TrunkPlacer)new CherryTrunkPlacer(7, 1, 0, (IntProvider)new WeightedListInt(WeightedList.m_384576_().m_385754_((Object)ConstantInt.m_146483_((int)1), 1).m_385754_((Object)ConstantInt.m_146483_((int)2), 1).m_385754_((Object)ConstantInt.m_146483_((int)3), 1).m_384449_()), (IntProvider)UniformInt.m_146622_((int)2, (int)4), UniformInt.m_146622_((int)-4, (int)-3), (IntProvider)UniformInt.m_146622_((int)-1, (int)0)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_271115_), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)4), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder sakura() {
        return MapleConfiguredFeatures.builder(Blocks.f_271170_, MapleBlocks.SAKURA_LEAVES.get(), 4, 2, 0, 2).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder sakura2() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_271170_), (TrunkPlacer)new FancyTrunkPlacer(8, 20, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)MapleBlocks.SAKURA_LEAVES.get()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(1))).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder ginkgo() {
        return MapleConfiguredFeatures.builder(MapleBlocks.GINKGO_LOG.get(), MapleBlocks.GINKGO_LEAVES.get(), 5, 2, 0, 2).m_68244_();
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> featureRegisterable) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.f_144267_);
        BlockMatchTest netherstoneReplaceables = new BlockMatchTest(Blocks.f_50134_);
        List<OreConfiguration.TargetBlockState> overworldSaltOres = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)MapleOreBlocks.Salt_Ore.get().m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)MapleOreBlocks.DEEPSLATE_Salt_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherCoalOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Coal_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherCopperOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Copper_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherDiamondOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Diamond_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherEmeraldOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Emerald_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherGoldOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Gold_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherIronOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Iron_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherLapisOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Lapis_Ore.get().m_49966_()));
        List<OreConfiguration.TargetBlockState> netherRedstoneOres = List.of(OreConfiguration.m_161021_((RuleTest)netherstoneReplaceables, (BlockState)MapleOreBlocks.Nether_Redstone_Ore.get().m_49966_()));
        MapleConfiguredFeatures.register(featureRegisterable, LAKE_HOT_SPRING, Feature.f_65783_, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)MapleFluidBlockOrItem.Hot_Spring_BLOCK.get().m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50440_.m_49966_())));
        MapleConfiguredFeatures.register(featureRegisterable, Red_Maple_TREE, Feature.f_65760_, MapleConfiguredFeatures.redmaple().m_68251_());
        MapleConfiguredFeatures.register(featureRegisterable, Maple_TREE, Feature.f_65760_, MapleConfiguredFeatures.maple().m_68251_());
        MapleConfiguredFeatures.register(featureRegisterable, CHERRY_TREE, Feature.f_65760_, MapleConfiguredFeatures.cherry().m_68251_());
        MapleConfiguredFeatures.register(featureRegisterable, SAKURA_TREE, Feature.f_65760_, MapleConfiguredFeatures.sakura().m_68251_());
        MapleConfiguredFeatures.register(featureRegisterable, MAGE_SAKURA_TREE, Feature.f_65760_, MapleConfiguredFeatures.sakura2().m_68251_());
        MapleConfiguredFeatures.register(featureRegisterable, GINKGO_TREE, Feature.f_65760_, MapleConfiguredFeatures.ginkgo().m_68251_());
        MapleConfiguredFeatures.register(featureRegisterable, SALT_ORE, Feature.f_65731_, new OreConfiguration(overworldSaltOres, 12));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Coal_ORE_KEY, Feature.f_65731_, new OreConfiguration(netherCoalOres, 10));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Copper_KEY, Feature.f_65731_, new OreConfiguration(netherCopperOres, 8));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Diamond_KEY, Feature.f_65731_, new OreConfiguration(netherDiamondOres, 8));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Emerald_KEY, Feature.f_65731_, new OreConfiguration(netherEmeraldOres, 3));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Gold_KEY, Feature.f_65731_, new OreConfiguration(netherGoldOres, 8));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Iron_KEY, Feature.f_65731_, new OreConfiguration(netherIronOres, 8));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Lapis_KEY, Feature.f_65731_, new OreConfiguration(netherLapisOres, 8));
        MapleConfiguredFeatures.register(featureRegisterable, Nether_Redstone_ORE_KEY, Feature.f_65731_, new OreConfiguration(netherRedstoneOres, 8));
        MapleConfiguredFeatures.register(featureRegisterable, Red_Maple_Carpet_KEY, Feature.f_65761_, new RandomPatchConfiguration(30, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)MapleBlocks.RED_MAPLE_CARPET.get())))));
        MapleConfiguredFeatures.register(featureRegisterable, Maple_Carpet_KEY, Feature.f_65761_, new RandomPatchConfiguration(30, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)MapleBlocks.Maple_CARPET.get())))));
        MapleConfiguredFeatures.register(featureRegisterable, Sakura_Carpet_KEY, Feature.f_65761_, new RandomPatchConfiguration(30, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)MapleBlocks.SAKURA_CARPET.get())))));
        MapleConfiguredFeatures.register(featureRegisterable, PATCH_TEA, Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)MapleBlocks.Tea_Block.get().m_49966_().m_61124_((Property)MapleTeaBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.f_50440_)));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocation.m_339182_((String)"maple", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_321889_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

