/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.client.gui.element;

import com.mikitellurium.telluriumforge.util.TextureSprite;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.util.FastLoc;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EnergyStorageElement {
    private static final ResourceLocation ENERGY_STORAGE_TEXTURE = FastLoc.ofMod("textures/gui/energy_storage.png");
    private final int textureWidth = 30;
    private final int textureHeight = 66;
    private final TurtleChargingStationBlockEntity station;
    private final TextureSprite emptyStorage;
    private final TextureSprite fullStorage;
    private final int xPos;
    private final int yPos;

    public EnergyStorageElement(TurtleChargingStationBlockEntity station, int xPos, int yPos) {
        this.station = station;
        this.emptyStorage = new TextureSprite(ENERGY_STORAGE_TEXTURE, 0, 0, 16, 66, xPos, yPos);
        this.fullStorage = new TextureSprite(ENERGY_STORAGE_TEXTURE, 16, 0, 14, 64, xPos + 1, yPos + 1);
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public void draw(GuiGraphics graphics) {
        graphics.m_280163_(this.emptyStorage.texture(), this.xPos, this.yPos, (float)this.emptyStorage.uOffset(), (float)this.emptyStorage.vOffset(), this.emptyStorage.width(), this.emptyStorage.height(), 30, 66);
        if (this.station.getEnergy() > 0) {
            this.drawEnergyLevel(graphics);
        }
    }

    private void drawEnergyLevel(GuiGraphics graphics) {
        graphics.m_280163_(this.fullStorage.texture(), this.fullStorage.xPos(), this.fullStorage.yPos() + this.getEnergyLevel(), (float)this.fullStorage.uOffset(), (float)this.getEnergyLevel(), this.fullStorage.width(), this.fullStorage.height() - this.getEnergyLevel(), 30, 66);
    }

    private int getEnergyLevel() {
        return this.fullStorage.height() - (int)Math.ceil((float)this.fullStorage.height() * ((float)this.station.getEnergy() / (float)this.station.getMaxEnergy()));
    }

    public Component getTooltip() {
        return Component.m_237113_((String)(this.station.getEnergy() + "/" + this.station.getMaxEnergy() + " FE"));
    }

    public Rect2i getArea() {
        return new Rect2i(this.xPos, this.yPos, this.emptyStorage.width(), this.emptyStorage.height());
    }
}

