/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.block;

import com.mikitellurium.telluriumforge.block.WaterloggedHelper;
import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.turtlechargingstation.common.blockentity.CopperCableBlockEntity;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import com.mikitellurium.turtlechargingstation.registry.ModBlocks;
import com.mikitellurium.turtlechargingstation.util.CableHelper;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class CopperCableBlock
extends BaseEntityBlock
implements WaterloggedHelper {
    public static final BooleanProperty BURNING = BooleanProperty.m_61465_((String)"burning");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final Map<Direction, BooleanProperty> CONNECTIONS = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.DOWN, DOWN);
        map.put(Direction.UP, UP);
        map.put(Direction.EAST, EAST);
        map.put(Direction.WEST, WEST);
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.SOUTH, SOUTH);
    });

    public CopperCableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BURNING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CopperCableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return CopperCableBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.COPPER_CABLE.get()), (BlockEntityTicker)TickingBlockEntity.getTicker());
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        Direction direction;
        if (((Boolean)blockState.m_61143_((Property)BURNING)).booleanValue() && random.m_188501_() < 0.7f && ((Boolean)blockState.m_61143_((Property)CONNECTIONS.get(direction = Direction.m_235672_((RandomSource)random)))).booleanValue()) {
            Vec3 vec3 = pos.m_252807_();
            double d0 = direction.m_122429_() == 0 ? this.getRandomOffset(random) : (double)direction.m_122429_() * (random.m_188500_() / 2.0);
            double d1 = direction.m_122430_() == 0 ? this.getRandomOffset(random) : (double)direction.m_122430_() * (random.m_188500_() / 2.0);
            double d2 = direction.m_122431_() == 0 ? this.getRandomOffset(random) : (double)direction.m_122431_() * (random.m_188500_() / 2.0);
            SimpleParticleType particleType = (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? ParticleTypes.f_123795_ : ParticleTypes.f_123762_;
            double ySpeed = (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? 0.2 : -0.01;
            level.m_7106_((ParticleOptions)particleType, vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2, 0.0, ySpeed, 0.0);
        }
    }

    private double getRandomOffset(RandomSource random) {
        return random.m_188503_(2) == 0 ? 0.18 : -0.18;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)blockState.m_61143_((Property)BURNING)).booleanValue()) {
            VoxelShape blockShape = blockState.m_60808_((BlockGetter)level, pos);
            AABB aabb = entity.m_20191_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())).m_82400_(0.01);
            if (!blockShape.m_83281_() && Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_)) {
                entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
            }
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CableHelper.getCableShape(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateFluid(blockState, level, pos);
        BlockState newState = this.updateBlockState(level, blockState, pos);
        if (!level.m_5776_() && newState != blockState) {
            level.m_141902_(pos, (BlockEntityType)ModBlockEntities.COPPER_CABLE.get()).ifPresent(CopperCableBlockEntity::updateConnections);
        }
        return newState;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        state.m_60701_((LevelAccessor)level, pos, 3);
        if (!level.f_46443_) {
            level.m_141902_(pos, (BlockEntityType)ModBlockEntities.COPPER_CABLE.get()).ifPresent(CopperCableBlockEntity::remove);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private BlockState updateBlockState(LevelAccessor level, BlockState blockState, BlockPos pos) {
        BlockState newState = blockState;
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            BlockPos relativePos = pos.m_121945_(direction);
            BlockState neighbourState = level.m_8055_(relativePos);
            boolean shouldConnect = neighbourState.m_60713_((Block)ModBlocks.COPPER_CABLE.get()) ? true : (blockEntity = level.m_7702_(relativePos)) != null && blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent();
            newState = (BlockState)newState.m_61124_((Property)CONNECTIONS.get(direction), (Comparable)Boolean.valueOf(shouldConnect));
        }
        return newState;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState blockState, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return (Boolean)blockState.m_61143_((Property)BURNING) != false ? BlockPathTypes.DAMAGE_FIRE : BlockPathTypes.WALKABLE;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter level, BlockPos pos, PathComputationType type) {
        return (Boolean)blockState.m_61143_((Property)BURNING) == false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = this.updateBlockState((LevelAccessor)context.m_43725_(), this.m_49966_(), context.m_8083_());
        return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(this.shouldWaterlogOnPlacement(context)));
    }

    public FluidState m_5888_(BlockState blockState) {
        return this.getFluidForBlockState(blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DOWN, UP, EAST, WEST, NORTH, SOUTH, WATERLOGGED, BURNING});
    }
}

