/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.block;

import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.telluriumforge.networking.SimplePacket;
import com.mikitellurium.telluriumforge.util.ContainerUtils;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.networking.Networking;
import com.mikitellurium.turtlechargingstation.networking.packets.EnergySyncS2CPacket;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import com.mikitellurium.turtlechargingstation.registry.ModBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TurtleChargingStationBlock
extends BaseEntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty CHARGING = BooleanProperty.m_61465_((String)"charging");

    public TurtleChargingStationBlock(BlockBehaviour.Properties properties) {
        super(properties.m_284180_(MapColor.f_283927_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.TRUE)).m_61124_((Property)CHARGING, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new TurtleChargingStationBlockEntity(pos, blockState);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TurtleChargingStationBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.TURTLE_CHARGING_STATION.get()), (BlockEntityTicker)TickingBlockEntity.getTicker());
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (!level.f_46443_) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof TurtleChargingStationBlockEntity) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((TurtleChargingStationBlockEntity)entity), (BlockPos)pos);
                Networking.HELPER.sendToClients((SimplePacket)new EnergySyncS2CPacket(((TurtleChargingStationBlockEntity)entity).getEnergyStorage().getEnergyStored(), pos));
            } else {
                throw new IllegalStateException("Container provider is missing");
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(blockState.m_60734_())) {
            this.checkPoweredState(level, pos, blockState);
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, blockState);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState blockState) {
        boolean flag;
        boolean bl = flag = !level.m_276867_(pos);
        if (flag != (Boolean)blockState.m_61143_((Property)ENABLED)) {
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockState, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockentity;
        if (itemStack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof TurtleChargingStationBlockEntity) {
            ((TurtleChargingStationBlockEntity)blockentity).setCustomName(itemStack.m_41786_());
        }
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder lootParams) {
        List drops = super.m_49635_(blockState, lootParams);
        for (ItemStack itemStack : drops) {
            TurtleChargingStationBlockEntity station;
            BlockEntity be;
            if (!itemStack.m_150930_(((Block)ModBlocks.TURTLE_CHARGING_STATION.get()).m_5456_()) || !((be = (BlockEntity)lootParams.m_287159_(LootContextParams.f_81462_)) instanceof TurtleChargingStationBlockEntity) || !(station = (TurtleChargingStationBlockEntity)be).hasCustomName()) continue;
            itemStack.m_41714_(station.m_5446_());
        }
        return drops;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof TurtleChargingStationBlockEntity) {
                TurtleChargingStationBlockEntity turtleChargingStation = (TurtleChargingStationBlockEntity)blockentity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)ContainerUtils.fromItemHandler((IItemHandler)turtleChargingStation.getItemHandler()));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(blockState, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED, CHARGING});
    }
}

