/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.telluriumforge.networking.SimplePacket;
import com.mikitellurium.turtlechargingstation.common.block.CopperCableBlock;
import com.mikitellurium.turtlechargingstation.common.energy.CableNetwork;
import com.mikitellurium.turtlechargingstation.common.energy.CableNetworkImpl;
import com.mikitellurium.turtlechargingstation.common.energy.NetworkNode;
import com.mikitellurium.turtlechargingstation.networking.Networking;
import com.mikitellurium.turtlechargingstation.networking.packets.CableIdSyncS2CPacket;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EmptyEnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperCableBlockEntity
extends BlockEntity
implements TickingBlockEntity,
NetworkNode {
    private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> EmptyEnergyStorage.INSTANCE);
    private CableNetwork cableNetwork;
    private boolean ignoreOnUpdate = false;
    private int burningTimer = 0;
    private int clientNetworkId = -1;

    public CopperCableBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.COPPER_CABLE.get(), pos, blockState);
    }

    public void serverTick(ServerLevel level, BlockPos blockPos, BlockState blockState) {
        if (this.burningTimer > 0) {
            if (!((Boolean)blockState.m_61143_((Property)CopperCableBlock.BURNING)).booleanValue()) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)CopperCableBlock.BURNING, (Comparable)Boolean.valueOf(true)));
            }
            --this.burningTimer;
        } else if (((Boolean)blockState.m_61143_((Property)CopperCableBlock.BURNING)).booleanValue()) {
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)CopperCableBlock.BURNING, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void setBurning() {
        this.burningTimer = 200;
    }

    public void updateConnections() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        Set<CopperCableBlockEntity> cableSet = this.getAdjacentCables();
        if (!cableSet.isEmpty()) {
            this.joinNetwork(cableSet);
        }
        if (!this.hasNetwork()) {
            this.setNetwork(new CableNetworkImpl(this));
        }
    }

    private void joinNetwork(Set<CopperCableBlockEntity> cableSet) {
        Optional<CableNetwork> optionalNetwork = cableSet.stream().filter(CopperCableBlockEntity::hasNetwork).map(CopperCableBlockEntity::getNetwork).max(Comparator.comparingInt(CableNetwork::size));
        optionalNetwork.ifPresent(network -> network.update(this));
    }

    public void remove() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.cableNetwork.removeNode(this);
        this.ignoreOnUpdate = true;
        Set<CopperCableBlockEntity> cableSet = this.getAdjacentCables();
        ArrayList cachedNetworks = new ArrayList();
        cableSet.forEach(cable -> {
            if (cable.hasNetwork() && !cachedNetworks.contains(cable.getNetwork())) {
                CableNetworkImpl newNetwork = new CableNetworkImpl((NetworkNode)cable);
                cachedNetworks.add(newNetwork);
                cable.setNetwork(newNetwork);
                cable.getNetwork().update((NetworkNode)cable);
            }
        });
    }

    public Set<CopperCableBlockEntity> getAdjacentCables() {
        HashSet<CopperCableBlockEntity> cableSet = new HashSet<CopperCableBlockEntity>();
        for (Direction direction : Direction.values()) {
            BlockPos relativePos = this.f_58858_.m_121945_(direction);
            BlockEntity blockEntity = this.f_58857_.getExistingBlockEntity(relativePos);
            if (!(blockEntity instanceof CopperCableBlockEntity)) continue;
            CopperCableBlockEntity cable = (CopperCableBlockEntity)blockEntity;
            if (cable.ignoreOnUpdate) continue;
            cableSet.add(cable);
        }
        return cableSet;
    }

    @Override
    public boolean hasNetwork() {
        return this.cableNetwork != null;
    }

    @Override
    public CableNetwork getNetwork() {
        return this.cableNetwork;
    }

    @Override
    public void setNetwork(CableNetwork cableNetwork) {
        Objects.requireNonNull(cableNetwork);
        this.cableNetwork = cableNetwork;
        this.syncClientId();
    }

    @Override
    public boolean ignoreOnUpdate() {
        return this.ignoreOnUpdate;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("networkId", this.cableNetwork != null ? ((CableNetworkImpl)this.cableNetwork).getId() : this.clientNetworkId);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag.m_128441_("networkId")) {
            this.setClientNetworkId(tag.m_128451_("networkId"));
        }
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.updateConnections();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.burningTimer = nbt.m_128451_("burningTimer");
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("burningTimer", this.burningTimer);
        super.m_183515_(nbt);
    }

    public void setClientNetworkId(int id) {
        this.clientNetworkId = id;
    }

    public int getClientNetworkId() {
        return this.f_58857_.f_46443_ ? this.clientNetworkId : -2;
    }

    private void syncClientId() {
        if (!FMLLoader.isProduction()) {
            Networking.HELPER.sendToClients((SimplePacket)new CableIdSyncS2CPacket(((CableNetworkImpl)this.cableNetwork).getId(), this.f_58858_));
        }
    }
}

