/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.turtlechargingstation.common.block.ThunderchargeDynamoBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.CopperCableBlockEntity;
import com.mikitellurium.turtlechargingstation.common.energy.NetworkNode;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EmptyEnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThunderchargeDynamoBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> EmptyEnergyStorage.INSTANCE);
    private int charge = 0;
    public static ForgeConfigSpec.IntValue TRANSFER_RATE;
    public static ForgeConfigSpec.IntValue RECHARGE_AMOUNT;

    public ThunderchargeDynamoBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.THUNDERCHARGE_DYNAMO.get(), blockPos, blockState);
    }

    public void serverTick(ServerLevel level, BlockPos blockPos, BlockState blockState) {
        if (this.charge > 0) {
            BlockEntity blockEntity = level.m_7702_(blockPos.m_121945_(Direction.DOWN));
            if (blockEntity != null) {
                NetworkNode node;
                if (blockEntity instanceof NetworkNode && (node = (NetworkNode)blockEntity).hasNetwork()) {
                    node.getNetwork().getReceivers().forEach(receiver -> receiver.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN).ifPresent(energyStorage -> energyStorage.receiveEnergy(((Integer)TRANSFER_RATE.get()).intValue(), false)));
                    node.getNetwork().getNodeByType(CopperCableBlockEntity.class).forEach(CopperCableBlockEntity::setBurning);
                } else {
                    blockEntity.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN).ifPresent(energyStorage -> energyStorage.receiveEnergy(((Integer)TRANSFER_RATE.get()).intValue(), false));
                }
            }
            --this.charge;
        }
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ThunderchargeDynamoBlock.POWERED, (Comparable)Boolean.valueOf(this.charge > 0)));
        ThunderchargeDynamoBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
    }

    public int getCharge() {
        return this.charge;
    }

    public void recharge() {
        this.charge = Math.min(this.getCharge() + (Integer)RECHARGE_AMOUNT.get(), Integer.MAX_VALUE);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == Direction.DOWN) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.charge = nbt.m_128451_("charge");
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("charge", this.charge);
        super.m_183515_(nbt);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }
}

