/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.blockentity.NameableBlockEntity;
import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.telluriumforge.energy.SimpleEnergyStorage;
import com.mikitellurium.telluriumforge.networking.SimplePacket;
import com.mikitellurium.turtlechargingstation.client.gui.TurtleChargingStationMenu;
import com.mikitellurium.turtlechargingstation.common.block.TurtleChargingStationBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlechargingstation.networking.Networking;
import com.mikitellurium.turtlechargingstation.networking.packets.EnergySyncS2CPacket;
import com.mikitellurium.turtlechargingstation.networking.packets.TurtleFuelSyncS2CPacket;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurtleChargingStationBlockEntity
extends NameableBlockEntity
implements TickingBlockEntity,
MenuProvider {
    public static final Capability<CCAccess> ACCESS_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<CCAccess>(){});
    public static ForgeConfigSpec.IntValue CAPACITY;
    public static ForgeConfigSpec.IntValue CONVERSION_RATE;
    private final int maxReceive = (Integer)CONVERSION_RATE.get() * 6;
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage((Integer)CAPACITY.get(), this.maxReceive){

        public void onEnergyChanged() {
            TurtleChargingStationBlockEntity.this.m_6596_();
            Networking.HELPER.sendToClients((SimplePacket)new EnergySyncS2CPacket(this.energy, TurtleChargingStationBlockEntity.this.f_58858_));
        }
    };
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TurtleChargingStationBlockEntity.this.m_6596_();
        }
    };
    private final CCAccess access = new CCAccess(){

        @Override
        public BlockPos getPos() {
            return TurtleChargingStationBlockEntity.this.f_58858_;
        }

        @Override
        public BlockState getBlockState() {
            return TurtleChargingStationBlockEntity.this.m_58900_();
        }

        @Override
        public Level getLevel() {
            return TurtleChargingStationBlockEntity.this.f_58857_;
        }
    };
    private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<CCAccess> lazyAccess = LazyOptional.of(() -> this.access);
    private final int textureChangeDelay = (int)Math.ceil((double)((Integer)CONVERSION_RATE.get()).intValue() / (double)((Integer)ThunderchargeDynamoBlockEntity.TRANSFER_RATE.get()).intValue()) + 1;
    private int textureTimer = 0;

    public TurtleChargingStationBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TURTLE_CHARGING_STATION.get(), pPos, pBlockState);
    }

    public void serverTick(ServerLevel level, BlockPos pos, BlockState state) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
            int extracted = energyStorage.extractEnergy(this.maxReceive, true);
            if (extracted > 0 && this.getEnergy() < this.getMaxEnergy()) {
                int energy = this.energyStorage.receiveEnergy(extracted, false);
                energyStorage.extractEnergy(energy, false);
            }
        });
        ArrayList<TurtleBlockEntity> turtles = new ArrayList<TurtleBlockEntity>();
        for (Direction direction : Direction.values()) {
            BlockEntity be = level.m_7702_(this.f_58858_.m_121945_(direction));
            if (be == null || !(be instanceof TurtleBlockEntity)) continue;
            turtles.add((TurtleBlockEntity)be);
        }
        boolean shouldCharge = !turtles.isEmpty() && this.hasChargeableTurtle(turtles) && this.energyStorage.getEnergyStored() >= (Integer)CONVERSION_RATE.get();
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)TurtleChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(shouldCharge || this.textureTimer > 0)), 2);
        if (shouldCharge && ((Boolean)this.m_58900_().m_61143_((Property)TurtleChargingStationBlock.ENABLED)).booleanValue()) {
            for (TurtleBlockEntity turtle : turtles) {
                if (!this.isChargeable(turtle) || this.energyStorage.getEnergyStored() < (Integer)CONVERSION_RATE.get()) continue;
                this.refuelTurtle(turtle);
                this.textureTimer = this.textureChangeDelay;
            }
        }
        if (this.textureTimer > 0) {
            --this.textureTimer;
        }
    }

    private boolean hasChargeableTurtle(List<TurtleBlockEntity> turtles) {
        for (TurtleBlockEntity turtle : turtles) {
            if (!this.isChargeable(turtle)) continue;
            return true;
        }
        return false;
    }

    private boolean isChargeable(TurtleBlockEntity turtle) {
        return turtle.getAccess().getFuelLevel() < turtle.getAccess().getFuelLimit();
    }

    private void refuelTurtle(TurtleBlockEntity turtle) {
        if (this.energyStorage.extractEnergy(((Integer)CONVERSION_RATE.get()).intValue(), false) == ((Integer)CONVERSION_RATE.get()).intValue()) {
            turtle.getAccess().addFuel(1);
            Networking.HELPER.sendToClients((SimplePacket)new TurtleFuelSyncS2CPacket(turtle.getAccess().getFuelLevel(), turtle.m_58899_()));
        }
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TurtleChargingStationMenu(id, inventory, (BlockEntity)this);
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.turtlechargingstation.turtle_charging_station");
    }

    public Component m_5446_() {
        return this.getName();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ACCESS_CAP) {
            return this.lazyAccess.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("turtle_charger.energy", this.energyStorage.getEnergyStored());
        nbt.m_128365_("turtle_charger.inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.setEnergy(nbt.m_128451_("turtle_charger.energy"));
        this.itemHandler.deserializeNBT(nbt.m_128469_("turtle_charger.inventory"));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
        this.lazyItemHandler.invalidate();
        this.lazyAccess.invalidate();
    }

    public static interface CCAccess {
        public BlockPos getPos();

        public BlockState getBlockState();

        public Level getLevel();
    }
}

