/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.energy;

import com.mikitellurium.turtlechargingstation.common.energy.CableNetwork;
import com.mikitellurium.turtlechargingstation.common.energy.NetworkNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class CableNetworkImpl
implements CableNetwork {
    private static int ids = 0;
    private final int id;
    private final Set<NetworkNode> nodes = new HashSet<NetworkNode>();
    private final Set<BlockEntity> receivers = new HashSet<BlockEntity>();

    private static int id() {
        return ++ids;
    }

    public CableNetworkImpl(NetworkNode node) {
        this.nodes.add(node);
        this.id = CableNetworkImpl.id();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int size() {
        return this.nodes.size() + this.receivers.size();
    }

    @Override
    public void update(NetworkNode startingPoint) {
        if (!startingPoint.m_58904_().f_46443_) {
            this.receivers.clear();
            Set<NetworkNode> nodes = this.findConnectedNodes(startingPoint.m_58904_(), startingPoint.m_58899_(), null, new HashSet<NetworkNode>());
            nodes.forEach(node -> {
                this.addNode((NetworkNode)node);
                this.findReceivers((NetworkNode)node);
            });
        }
    }

    private Set<NetworkNode> findConnectedNodes(Level level, BlockPos startPos, Direction startDirection, Set<NetworkNode> foundNodes) {
        BlockEntity blockEntity = level.m_7702_(startPos);
        if (blockEntity instanceof NetworkNode) {
            NetworkNode node = (NetworkNode)blockEntity;
            if (foundNodes.contains(node) || node.ignoreOnUpdate()) {
                return foundNodes;
            }
            foundNodes.add(node);
            for (Direction direction : Direction.values()) {
                BlockPos relativePos;
                BlockEntity blockEntity1;
                if (startDirection != null && direction == startDirection.m_122424_() || !((blockEntity1 = level.m_7702_(relativePos = startPos.m_121945_(direction))) instanceof NetworkNode)) continue;
                this.findConnectedNodes(level, relativePos, direction, foundNodes);
            }
        }
        return foundNodes;
    }

    private void findReceivers(NetworkNode node) {
        for (Direction direction : Direction.values()) {
            BlockPos relativePos = node.m_58899_().m_121945_(direction);
            BlockEntity blockEntity = node.m_58904_().m_7702_(relativePos);
            if (blockEntity == null || blockEntity instanceof NetworkNode || !blockEntity.getCapability(ForgeCapabilities.ENERGY, direction).isPresent()) continue;
            this.addReceiver(blockEntity);
        }
    }

    @Override
    public boolean addNode(NetworkNode node) {
        if (node != null) {
            node.setNetwork(this);
            return this.nodes.add(node);
        }
        return false;
    }

    @Override
    public void removeNode(NetworkNode node) {
        this.nodes.remove(node);
    }

    @Override
    public Collection<NetworkNode> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    @Override
    public boolean addReceiver(BlockEntity blockEntity) {
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return this.receivers.add(blockEntity);
        }
        return false;
    }

    @Override
    public boolean removeReceiver(BlockEntity blockEntity) {
        return this.receivers.remove(blockEntity);
    }

    @Override
    public Collection<BlockEntity> getReceivers() {
        return Collections.unmodifiableSet(this.receivers);
    }

    @Override
    public boolean contains(BlockEntity blockEntity) {
        return blockEntity instanceof NetworkNode ? this.nodes.contains(blockEntity) : this.receivers.contains(blockEntity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[Id:" + this.id + ", Nodes:" + this.nodes.size() + ", Receivers:" + this.receivers.size() + "]";
    }
}

